/*
 * Decompiled with CFR 0.152.
 */
package com.boatyExcited;

import com.boatyExcited.Sound;
import com.boatyExcited.SoundEngine;
import com.boatyExcited.SoundFileManager;
import com.boatyExcited.boatyExcitedConfig;
import com.google.inject.Provides;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.Skill;
import net.runelite.api.TileItem;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.api.events.StatChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsPlugin;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Boaty Hype man")
@PluginDependency(value=GroundItemsPlugin.class)
public class boatyExcitedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(boatyExcitedPlugin.class);
    private static final String DELETE_WARNING_FILENAME = "EXTRA_FILES_WILL_BE_DELETED_BUT_FOLDERS_WILL_REMAIN";
    private static final File DOWNLOAD_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "boaty-excited");
    private static final File DELETE_WARNING_FILE = new File(DOWNLOAD_DIR, "EXTRA_FILES_WILL_BE_DELETED_BUT_FOLDERS_WILL_REMAIN");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ItemManager itemManager;
    private static final Random random = new Random();
    @Inject
    private GroundItemsConfig groundItemsConfig;
    @Inject
    private boatyExcitedConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private OkHttpClient okHttpClient;
    private final Map<Skill, Integer> oldExperience = new EnumMap<Skill, Integer>(Skill.class);
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*");
    private static final Pattern COMBAT_TASK_REGEX = Pattern.compile("Congratulations, you've completed an? (?:\\w+) combat task:.*");
    private static final Pattern QUEST_REGEX = Pattern.compile("Congratulations, you've completed a quest:.*");
    private static final Pattern HIGHLIGHTED_ITEM = Pattern.compile("^(.+)([<>])([0-9]+)$");
    private static final String FOLLOW_PET = "You have a funny feeling like you're being followed";
    private static final String INVENTORY_PET = "You feel something weird sneaking into your backpack";
    private static final String DUPE_PET = "You have a funny feeling like you would have been followed";
    private boolean isLoggedIn = false;

    protected void startUp() throws Exception {
        this.executor.submit(() -> {
            SoundFileManager.ensureDownloadDirectoryExists();
            SoundFileManager.downloadAllMissingSounds(this.okHttpClient);
        });
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (!this.isLoggedIn && event.getGameState().equals((Object)GameState.LOGGED_IN) && this.config.announceLogin()) {
            SoundEngine.playSound(Sound.LOGIN, this.config.announcementVolume());
            this.isLoggedIn = true;
            return;
        }
        if (event.getGameState().equals((Object)GameState.LOGIN_SCREEN) && this.isLoggedIn) {
            this.isLoggedIn = false;
            return;
        }
    }

    @Provides
    boatyExcitedConfig provideConfig(ConfigManager configManager) {
        return (boatyExcitedConfig)configManager.getConfig(boatyExcitedConfig.class);
    }

    public static void ensureDownloadDirectoryExists() {
        if (!DOWNLOAD_DIR.exists()) {
            DOWNLOAD_DIR.mkdirs();
        }
        try {
            DELETE_WARNING_FILE.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean itemListContains(String list, String itemName, int quantity) {
        String[] listItems;
        for (String listItem : listItems = list.split(",")) {
            if ((listItem = listItem.trim()).equalsIgnoreCase(itemName)) {
                return true;
            }
            Matcher m = HIGHLIGHTED_ITEM.matcher(listItem);
            if (!m.find() || !m.group(1).equalsIgnoreCase(itemName)) continue;
            String comparison = m.group(2);
            int quantityLimit = Integer.parseInt(m.group(3));
            if (!(comparison.equals(">") ? quantity > quantityLimit : quantity < quantityLimit)) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        if (!this.config.announceDrops()) {
            return;
        }
        TileItem item = itemSpawned.getItem();
        int id = item.getId();
        int quantity = item.getQuantity();
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        String itemName = itemComposition.getName();
        String hiddenItems = this.configManager.getConfiguration("grounditems", "hiddenItems");
        if (boatyExcitedPlugin.itemListContains(hiddenItems, itemName, quantity)) {
            return;
        }
        int notifyValue = Integer.parseInt(this.configManager.getConfiguration("grounditems", "highValuePrice"));
        if (notifyValue <= itemComposition.getPrice()) {
            SoundEngine.playSound(Sound.money[random.nextInt(Sound.money.length)], this.config.announcementVolume());
            return;
        }
        String highlightedItems = this.configManager.getConfiguration("grounditems", "highlightedItems");
        if (boatyExcitedPlugin.itemListContains(highlightedItems, itemName, quantity)) {
            SoundEngine.playSound(Sound.money[random.nextInt(Sound.money.length)], this.config.announcementVolume());
            return;
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        if (this.config.announceDeath() && actorDeath.getActor() == this.client.getLocalPlayer()) {
            SoundEngine.playSound(Sound.death[random.nextInt(Sound.death.length)], this.config.announcementVolume());
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        if (hitsplatApplied.getHitsplat().isMine() && (hitsplatApplied.getHitsplat().getHitsplatType() == 45 || hitsplatApplied.getHitsplat().getHitsplatType() == 20 || hitsplatApplied.getHitsplat().getHitsplatType() == 43) && this.config.announceMaxHit()) {
            SoundEngine.playSound(Sound.MAXHIT, this.config.announcementVolume());
        }
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed event) {
        int soundId = event.getSoundId();
        if (this.config.rubyBoltSpec() && soundId == 2911) {
            event.consume();
            SoundEngine.playSound(Sound.RUBYSPEC, this.config.announcementVolume());
            return;
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int xpAfter = this.client.getSkillExperience(skill);
        int levelAfter = Experience.getLevelForXp((int)xpAfter);
        int xpBefore = this.oldExperience.getOrDefault(skill, -1);
        int levelBefore = xpBefore == -1 ? -1 : Experience.getLevelForXp((int)xpBefore);
        this.oldExperience.put(skill, xpAfter);
        if (xpBefore == -1 || xpAfter <= xpBefore || levelBefore >= levelAfter) {
            return;
        }
        if (this.config.announceLevelUp()) {
            SoundEngine.playSound(Sound.levelup[random.nextInt(Sound.levelup.length)], this.config.announcementVolume());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (this.config.announceCollectionLog() && COLLECTION_LOG_ITEM_REGEX.matcher(chatMessage.getMessage()).matches()) {
            SoundEngine.playSound(Sound.collLog[random.nextInt(Sound.collLog.length)], this.config.announcementVolume());
        } else if (this.config.announceCombatAchievement() && COMBAT_TASK_REGEX.matcher(chatMessage.getMessage()).matches()) {
            SoundEngine.playSound(Sound.combat_task[random.nextInt(Sound.combat_task.length)], this.config.announcementVolume());
        } else if (this.config.announceQuestCompletion() && QUEST_REGEX.matcher(chatMessage.getMessage()).matches()) {
            SoundEngine.playSound(Sound.quest[random.nextInt(Sound.quest.length)], this.config.announcementVolume());
        } else if (this.config.announcePets() && chatMessage.getMessage().contains(FOLLOW_PET)) {
            SoundEngine.playSound(Sound.PET, this.config.announcementVolume());
        } else if (this.config.announcePets() && chatMessage.getMessage().contains(INVENTORY_PET)) {
            SoundEngine.playSound(Sound.PET, this.config.announcementVolume());
        } else if (this.config.announcePets() && chatMessage.getMessage().contains(DUPE_PET)) {
            SoundEngine.playSound(Sound.PET, this.config.announcementVolume());
        }
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }
}

