/*
 * Decompiled with CFR 0.152.
 */
package com.boatyExcited;

import com.boatyExcited.Sound;
import com.boatyExcited.SoundFileManager;
import com.boatyExcited.boatyExcitedConfig;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundEngine {
    private static final Logger log = LoggerFactory.getLogger(SoundEngine.class);
    @Inject
    private static boatyExcitedConfig config;
    private static Clip clip;

    public static void playSound(Sound sound, int volume) {
        try {
            BufferedInputStream stream = new BufferedInputStream(SoundFileManager.getSoundStream(sound));
            AudioInputStream is = AudioSystem.getAudioInputStream(stream);
            AudioFormat format = is.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(is);
            SoundEngine.setVolume(volume);
            clip.start();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Sound file error", (Throwable)e);
        }
    }

    private static void setVolume(int value) {
        float vol = (float)value / 100.0f;
        FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
        gainControl.setValue(20.0f * (float)Math.log10(vol));
    }

    static {
        clip = null;
    }
}

