/*
 * Decompiled with CFR 0.152.
 */
package com.theleruby.rune.updater;

import com.google.inject.Provides;
import com.theleruby.rune.updater.TheleruneUpdaterConfig;
import java.io.IOException;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="TheleRune Updater", description="Updates TheleRune on logout", enabledByDefault=false)
public class TheleruneUpdaterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TheleruneUpdaterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TheleruneUpdaterConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    private long lastAccountHash;
    private boolean shouldProcessLogin;
    private long lastExperienceValue;
    HashSet<WorldType> unsupportedWorldTypes;

    protected void startUp() throws Exception {
        this.shouldProcessLogin = true;
        this.lastAccountHash = -1L;
        this.unsupportedWorldTypes = new HashSet();
        this.unsupportedWorldTypes.add(WorldType.SEASONAL);
        this.unsupportedWorldTypes.add(WorldType.DEADMAN);
        this.unsupportedWorldTypes.add(WorldType.NOSAVE_MODE);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state == GameState.LOGGED_IN && this.lastAccountHash != this.client.getAccountHash()) {
            this.lastAccountHash = this.client.getAccountHash();
            this.shouldProcessLogin = true;
        } else if (state == GameState.LOGIN_SCREEN) {
            Player local = this.client.getLocalPlayer();
            if (local == null) {
                return;
            }
            for (WorldType worldType : this.client.getWorldType()) {
                if (!this.unsupportedWorldTypes.contains(worldType)) continue;
                log.debug("Unsupported world type {}", (Object)worldType.name());
                return;
            }
            long totalExperienceValue = this.client.getOverallExperience();
            long experienceDiff = totalExperienceValue - this.lastExperienceValue;
            if (experienceDiff >= 0L && experienceDiff >= (long)this.config.minXP()) {
                log.info("Submitting update for {}", (Object)local.getName());
                HttpUrl url = new HttpUrl.Builder().scheme("https").host("rune.theleruby.com").addPathSegment("api").addPathSegment("update").addPathSegment(local.getName().replace(" ", "_")).addPathSegment("").addQueryParameter("api_key", this.config.apiKey()).build();
                Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).build();
                this.okHttpClient.newCall(request).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        log.warn("Updating TheleRune failed ({})", (Object)e.getMessage());
                    }

                    public void onResponse(Call call, Response response) {
                        log.debug("Update said {}", (Object)response.message());
                        response.close();
                    }
                });
                this.lastExperienceValue = totalExperienceValue;
            } else {
                log.debug("Not enough XP earned to submit update ({} of {} earned)", (Object)experienceDiff, (Object)this.config.minXP());
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.shouldProcessLogin) {
            this.lastExperienceValue = this.client.getOverallExperience();
            this.shouldProcessLogin = false;
        }
    }

    @Provides
    TheleruneUpdaterConfig provideConfig(ConfigManager configManager) {
        return (TheleruneUpdaterConfig)configManager.getConfig(TheleruneUpdaterConfig.class);
    }
}

