/*
 * Decompiled with CFR 0.152.
 */
package com.crabstuntimer;

import com.crabstuntimer.CrabStun;
import com.crabstuntimer.CrabStunConfig;
import com.crabstuntimer.CrabStunOverlay;
import com.crabstuntimer.TeamSize;
import com.google.inject.Provides;
import java.awt.Point;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Crab Stun Timers", description="Show crab stun timers", tags={"overlay", "raid", "pvm", "timers"})
public class CrabStunPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CrabStunPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CrabStunOverlay overlay;
    private final List<CrabStun> stunEvents = new ArrayList<CrabStun>();

    @Provides
    CrabStunConfig getConfig(ConfigManager configManager) {
        return (CrabStunConfig)configManager.getConfig(CrabStunConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        if (this.client.getVarbitValue(5432) != 1) {
            return;
        }
        int CRAB_STUN_GRAPHIC = 245;
        Actor actor = event.getActor();
        if (actor.getName() != null && actor.getName().contains("Jewelled Crab") && actor.getGraphic() == 245) {
            WorldPoint worldPoint = actor.getWorldLocation();
            CrabStun stunEvent = new CrabStun(actor, worldPoint, Instant.now(), this.getStunDurationTicks(), 0);
            for (CrabStun stun : this.stunEvents) {
                if (!stun.getCrab().equals(actor)) continue;
                stun.setStartTime(Instant.now());
            }
            this.overlay.getRandomIntervalTimers().removeIf(timer -> timer.getCrab().equals(stunEvent.getCrab()));
            this.stunEvents.add(stunEvent);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Iterator<CrabStun> it = this.overlay.getRandomIntervalTimers().iterator();
        while (it.hasNext()) {
            try {
                Point crabCurrentPoint;
                CrabStun stun = it.next();
                Point crabStunPoint = new Point(stun.getWorldPoint().getX(), stun.getWorldPoint().getY());
                if (!(crabStunPoint.distance(crabCurrentPoint = new Point(stun.getCrab().getWorldLocation().getX(), stun.getCrab().getWorldLocation().getY())) > 0.0)) continue;
                it.remove();
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private int getStunDurationTicks() {
        switch (this.client.getVarbitValue(5424)) {
            case 1: {
                return TeamSize.ONE.getStunDuration();
            }
            case 2: 
            case 3: {
                return TeamSize.TWO_TO_THREE.getStunDuration();
            }
            case 4: 
            case 5: {
                return TeamSize.FOUR_TO_FIVE.getStunDuration();
            }
        }
        return TeamSize.SIX_PLUS.getStunDuration();
    }

    List<CrabStun> getStunEvents() {
        return this.stunEvents;
    }
}

