/*
 * Decompiled with CFR 0.152.
 */
package com.crabstuntimer;

import com.crabstuntimer.CrabStun;
import com.crabstuntimer.CrabStunConfig;
import com.crabstuntimer.CrabStunPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;
import net.runelite.client.ui.overlay.components.TextComponent;

class CrabStunOverlay
extends Overlay {
    private final Client client;
    private final CrabStunPlugin plugin;
    private List<CrabStun> randomIntervalTimers = new ArrayList<CrabStun>();
    @Inject
    private CrabStunConfig config;

    @Inject
    private CrabStunOverlay(Client client, CrabStunPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        List<CrabStun> stunEvents = this.plugin.getStunEvents();
        this.renderGraphicsFromCrabStunList(stunEvents, graphics, false);
        this.renderGraphicsFromCrabStunList(this.randomIntervalTimers, graphics, true);
        return null;
    }

    private void renderGraphicsFromCrabStunList(List<CrabStun> stunEvents, Graphics2D graphics, boolean inRandomInterval) {
        if (stunEvents.isEmpty()) {
            return;
        }
        Instant now = Instant.now();
        Iterator<CrabStun> it = stunEvents.iterator();
        while (it.hasNext()) {
            Color pieFillColor = inRandomInterval ? this.config.randomTimerColor() : this.config.normalTimerColor();
            Color pieBorderColor = inRandomInterval ? this.config.randomBorderColor() : this.config.timerBorderColor();
            CrabStun stun = it.next();
            float stunDurationMillis = (float)((double)stun.getStunDurationTicks() * 0.6 * 1000.0);
            float percent = (float)(now.toEpochMilli() - stun.getStartTime().toEpochMilli()) / stunDurationMillis;
            float millisLeft = stunDurationMillis - (float)(now.toEpochMilli() - stun.getStartTime().toEpochMilli());
            double secondsLeft = (double)Math.round((double)millisLeft / 100.0) / 10.0;
            WorldPoint worldPoint = stun.getWorldPoint();
            LocalPoint loc = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
            if ((double)percent >= 0.9) {
                pieFillColor = this.config.timerWarningColor();
            }
            if (loc == null) {
                it.remove();
                continue;
            }
            if (percent > 1.0f) {
                if (!inRandomInterval) {
                    this.randomIntervalTimers.add(new CrabStun(stun.getCrab(), stun.getWorldPoint(), Instant.now(), 10, 0));
                }
                it.remove();
                continue;
            }
            Point point = Perspective.localToCanvas((Client)this.client, (LocalPoint)loc, (int)this.client.getPlane(), (int)stun.getZOffset());
            if (point == null) {
                it.remove();
                continue;
            }
            if (this.config.showTimer()) {
                ProgressPieComponent ppc = new ProgressPieComponent();
                ppc.setBorderColor(pieBorderColor);
                ppc.setFill(pieFillColor);
                ppc.setPosition(point);
                ppc.setProgress((double)percent);
                ppc.setDiameter(this.config.timerDiameter());
                ppc.render(graphics);
            }
            if (!this.config.showText()) continue;
            TextComponent tc = new TextComponent();
            switch (this.config.textType()) {
                case SECONDS: {
                    tc.setText(secondsLeft + (inRandomInterval ? "?" : ""));
                    break;
                }
                case TICKS: {
                    tc.setText(Math.round((double)millisLeft / 1000.0 / 0.6) + (inRandomInterval ? "?" : ""));
                }
            }
            tc.setColor(pieFillColor);
            tc.setPosition(new java.awt.Point(point.getX() - 5, point.getY() - 17));
            tc.render(graphics);
        }
    }

    List<CrabStun> getRandomIntervalTimers() {
        return this.randomIntervalTimers;
    }
}

