/*
 * Decompiled with CFR 0.152.
 */
package com.butlerinfo;

import com.butlerinfo.ButlerInfoConfig;
import com.butlerinfo.ButlerInfoPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.NumberFormat;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class ServantOverlay
extends OverlayPanel {
    private final ButlerInfoPlugin plugin;
    private final ButlerInfoConfig config;

    @Inject
    private ServantOverlay(ButlerInfoPlugin plugin, ButlerInfoConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPreferredPosition(OverlayPosition.BOTTOM_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getServant() == null || this.config.onlyInBuildingMode() && !this.plugin.getPlayerOwnedHouse().isBuildingMode()) {
            return null;
        }
        if (this.config.showTotalAmountPayed()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Total gp payed:").right(NumberFormat.getNumberInstance(Locale.US).format(this.plugin.getServant().getTotalPayed())).build());
        }
        if (this.config.showTotalBankTrips()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Bank trips made:").right(Integer.toString(this.plugin.getServant().getTotalBankTripsMade())).build());
        }
        return super.render(graphics);
    }
}

