/*
 * Decompiled with CFR 0.152.
 */
package com.butlerinfo;

import com.butlerinfo.ButlerInfoPlugin;
import com.butlerinfo.ConstructionItem;
import com.butlerinfo.ServantType;

public class Servant {
    public static final int TRIPS_PER_PAYMENT = 8;
    private final ServantType type;
    private ButlerInfoPlugin plugin;
    private ConstructionItem item;
    private int itemAmountHeld;
    private int tripsUntilPayment;
    private int prevTripsUntilPayment;
    private int paymentAmount;
    private int totalPayed;
    private int totalBankTripsMade;

    Servant(ServantType type) {
        this.type = type;
        this.tripsUntilPayment = 0;
        this.prevTripsUntilPayment = 0;
        this.itemAmountHeld = 0;
        this.totalPayed = 0;
        this.totalBankTripsMade = 0;
    }

    public void setItem(String itemName) {
        ConstructionItem.getByName(this.singularize(itemName)).ifPresent(item -> {
            this.item = item;
        });
    }

    public void setItemAmountHeld(int value) {
        this.itemAmountHeld = value;
        this.plugin.renderItemCounter();
    }

    public void setTripsUntilPayment(int value) {
        this.setPrevTripsUntilPayment(this.tripsUntilPayment);
        this.tripsUntilPayment = Math.max(value, 0);
        this.plugin.renderTripsUntilPayment();
    }

    public void sendOnBankTrip() {
        this.plugin.startBankTripTimer();
        this.incrementTotalBankTripsMade();
        this.setTripsUntilPayment(this.tripsUntilPayment - 1);
    }

    public void sendOnBankTrip(String item) {
        this.setItem(item);
        this.sendOnBankTrip();
    }

    public void finishBankTrip(int itemAmountHeld) {
        this.plugin.setBankTimerReset(false);
        this.setItemAmountHeld(itemAmountHeld);
    }

    public void addPaymentToTotal(int paymentAmount) {
        this.totalPayed += paymentAmount;
    }

    public void incrementTotalBankTripsMade() {
        ++this.totalBankTripsMade;
    }

    private String singularize(String item) {
        if (item.charAt(item.length() - 1) == 's') {
            return item.substring(0, item.length() - 1);
        }
        return item;
    }

    public ServantType getType() {
        return this.type;
    }

    public void setPlugin(ButlerInfoPlugin plugin) {
        this.plugin = plugin;
    }

    public ConstructionItem getItem() {
        return this.item;
    }

    public int getItemAmountHeld() {
        return this.itemAmountHeld;
    }

    public int getTripsUntilPayment() {
        return this.tripsUntilPayment;
    }

    public int getPrevTripsUntilPayment() {
        return this.prevTripsUntilPayment;
    }

    public void setPrevTripsUntilPayment(int prevTripsUntilPayment) {
        this.prevTripsUntilPayment = prevTripsUntilPayment;
    }

    public int getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(int paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public int getTotalPayed() {
        return this.totalPayed;
    }

    public int getTotalBankTripsMade() {
        return this.totalBankTripsMade;
    }
}

