/*
 * Decompiled with CFR 0.152.
 */
package com.butlerinfo;

import com.butlerinfo.ButlerInfoPlugin;
import com.butlerinfo.ChatContinue;
import com.butlerinfo.ChatContinueEvent;
import com.butlerinfo.ChatOption;
import com.butlerinfo.ChatOptionEvent;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.util.Text;

public class DialogManager
implements KeyListener {
    private static final int MENU_OPTION_HOTKEY_SCRIPT_ID = 2153;
    private static final int CONTINUE_OPTION = -1;
    @Inject
    private Client client;
    private ButlerInfoPlugin plugin;
    private boolean enteringAmount;

    @Inject
    public DialogManager(ButlerInfoPlugin plugin) {
        this.plugin = plugin;
        this.enteringAmount = false;
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 32: {
                this.handleDialogAction(-1);
                break;
            }
            case 49: {
                this.handleDialogAction(1);
                break;
            }
            case 50: {
                this.handleDialogAction(2);
                break;
            }
            case 51: {
                this.handleDialogAction(3);
                break;
            }
            case 52: {
                this.handleDialogAction(4);
                break;
            }
            case 53: {
                this.handleDialogAction(5);
                break;
            }
            case 10: {
                if (!this.isEnteringAmount()) break;
                this.setEnteringAmount(false);
                this.plugin.getServant().sendOnBankTrip();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.WIDGET_CONTINUE) {
            this.handleDialogAction(event.getParam0());
        }
    }

    private void handleDialogAction(int selectedOption) {
        if (selectedOption == -1) {
            Widget npcDialogWidget = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
            this.fireChatContinueEvent(npcDialogWidget);
        } else {
            Widget playerDialogueOptionsWidget = this.client.getWidget(219, 1);
            this.fireChatOptionEvent(playerDialogueOptionsWidget, selectedOption);
        }
    }

    private void fireChatContinueEvent(Widget widget) {
        if (widget == null) {
            return;
        }
        String text = Text.sanitizeMultilineText((String)widget.getText());
        ChatContinueEvent continueEvent = new ChatContinueEvent(this.plugin, text);
        ChatContinue chatContinue = ChatContinue.getByEvent(continueEvent);
        if (chatContinue != null) {
            chatContinue.executeAction(continueEvent, chatContinue);
        }
    }

    private void fireChatOptionEvent(Widget widget, int selectedOption) {
        if (widget == null || widget.getChildren() == null) {
            return;
        }
        Widget[] dialogueOptions = widget.getChildren();
        ChatOptionEvent chatOptionEvent = new ChatOptionEvent(this.plugin, dialogueOptions[0].getText(), dialogueOptions[selectedOption].getText(), selectedOption);
        ChatOption chatOption = ChatOption.getByEvent(chatOptionEvent);
        if (chatOption != null) {
            chatOption.executeAction(chatOptionEvent, chatOption);
        }
    }

    public ButlerInfoPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isEnteringAmount() {
        return this.enteringAmount;
    }

    public void setEnteringAmount(boolean enteringAmount) {
        this.enteringAmount = enteringAmount;
    }
}

