/*
 * Decompiled with CFR 0.152.
 */
package com.butlerinfo;

import java.util.Optional;

public enum ConstructionItem {
    PLANK("Wooden plank", 960),
    OAK_PLANK("Oak plank", 8778),
    TEAK_PLANK("Teak plank", 8780),
    MAHOGANY_PLANK("Mahogany plank", 8782),
    SOFT_CLAY("Soft clay", 1761),
    LIMESTONE_BRICK("Limestone brick", 3420),
    STEEL_BAR("Steel bar", 2353),
    BOLT_OF_CLOTH("Cloth", 8790),
    GOLD_LEAF("Gold leaf", 4692),
    MARBLE_BLOCK("Marble block", 8786),
    MAGIC_STONE("Magic housing stone", 4703);

    private final String name;
    private final int itemId;

    private ConstructionItem(String name, int itemId) {
        this.name = name;
        this.itemId = itemId;
    }

    public static Optional<ConstructionItem> getByName(String name) {
        for (ConstructionItem item : ConstructionItem.values()) {
            if (!item.getName().equals(name)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public int getItemId() {
        return this.itemId;
    }
}

