/*
 * Decompiled with CFR 0.152.
 */
package com.butlerinfo;

import com.butlerinfo.ChatContinueEvent;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public enum ChatContinue {
    NOT_ENOUGH_IN_BANK("^Master, I dearly wish that I could perform your instruction in full, but alas, I can only carry (\\d+) items.", (event, option) -> event.getPlugin().getServant().sendOnBankTrip()),
    SEND_ITEMS_BACK_CONFIRMATION("Very well, Master.", (event, option) -> {
        if (event.getPlugin().isSendingItemsBack()) {
            event.getPlugin().setSendingItemsBack(false);
            event.getPlugin().getServant().setItemAmountHeld(0);
            event.getPlugin().startBankTripTimer();
        }
    });

    private final String text;
    private final BiConsumer<ChatContinueEvent, ChatContinue> action;

    private ChatContinue(String text, BiConsumer<ChatContinueEvent, ChatContinue> action) {
        this.text = text;
        this.action = action;
    }

    public void executeAction(ChatContinueEvent event, ChatContinue option) {
        if (event.getPlugin().getServant() == null) {
            return;
        }
        this.action.accept(event, option);
    }

    public Pattern getTextPattern() {
        return Pattern.compile(this.text);
    }

    public static ChatContinue getByEvent(ChatContinueEvent event) {
        for (ChatContinue option : ChatContinue.values()) {
            if (!option.getTextPattern().matcher(event.getText()).find()) continue;
            return option;
        }
        return null;
    }

    public String getText() {
        return this.text;
    }
}

