/*
 * Decompiled with CFR 0.152.
 */
package com.butlerinfo;

import com.butlerinfo.BankTripTimer;
import com.butlerinfo.ButlerInfoConfig;
import com.butlerinfo.DialogManager;
import com.butlerinfo.ItemCounter;
import com.butlerinfo.PlayerOwnedHouse;
import com.butlerinfo.Servant;
import com.butlerinfo.ServantOverlay;
import com.butlerinfo.ServantType;
import com.butlerinfo.TripsUntilPaymentCounter;
import com.google.inject.Provides;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Butler Info")
public class ButlerInfoPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ButlerInfoPlugin.class);
    private static final Pattern ITEM_AMOUNT_MATCHER = Pattern.compile("^Master, I have returned with what thou asked me to retrieve. As I see thy inventory is full, I shall wait with these (\\d+) items until thou art ready.");
    private static final Pattern NOT_ENOUGH_IN_BANK_MATCHER = Pattern.compile("^Master, I dearly wish that I could perform your instruction in full, but alas, I can only carry (\\d+) items.");
    private static final String SINGLE_ITEM_TEXT = "Master, I have returned with what thou asked me to retrieve. As I see thy inventory is full, I shall wait with the last item until thou art ready.";
    private static final String NO_EXTRA_ITEMS_TEXT = "Master, I have returned with what you asked me to retrieve.";
    @Inject
    private Client client;
    @Inject
    private ButlerInfoConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ServantOverlay servantOverlay;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PlayerOwnedHouse playerOwnedHouse;
    @Inject
    private EventBus eventBus;
    @Inject
    private KeyManager keyManager;
    @Inject
    private DialogManager dialogManager;
    private Servant servant;
    private BankTripTimer bankTripTimer;
    private ItemCounter itemCounter;
    private TripsUntilPaymentCounter tripsUntilPaymentCounter;
    private boolean sendingItemsBack = false;
    private boolean bankTimerReset = false;

    @Provides
    ButlerInfoConfig provideConfig(ConfigManager configManager) {
        return (ButlerInfoConfig)configManager.getConfig(ButlerInfoConfig.class);
    }

    protected void startUp() {
        this.eventBus.register((Object)this.playerOwnedHouse);
        this.eventBus.register((Object)this.dialogManager);
        this.keyManager.registerKeyListener((KeyListener)this.dialogManager);
        this.overlayManager.add((Overlay)this.servantOverlay);
    }

    protected void shutDown() {
        this.eventBus.unregister((Object)this.playerOwnedHouse);
        this.eventBus.unregister((Object)this.dialogManager);
        this.keyManager.unregisterKeyListener((KeyListener)this.dialogManager);
        this.overlayManager.remove((Overlay)this.servantOverlay);
        this.removeAll();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING && this.config.shouldResetSession()) {
            this.servant = null;
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.servant == null) {
            return;
        }
        Widget npcDialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (npcDialog == null) {
            return;
        }
        String text = Text.sanitizeMultilineText((String)npcDialog.getText());
        Matcher itemAmountMatcher = ITEM_AMOUNT_MATCHER.matcher(text);
        Matcher notEnoughInBankMatcher = NOT_ENOUGH_IN_BANK_MATCHER.matcher(text);
        if (itemAmountMatcher.find()) {
            this.servant.finishBankTrip(Integer.parseInt(itemAmountMatcher.group(1)));
        }
        if (notEnoughInBankMatcher.find() && !this.isBankTimerReset()) {
            this.setBankTimerReset(true);
            this.removeBankTripTimer(false);
            this.servant.setTripsUntilPayment(this.servant.getPrevTripsUntilPayment());
        }
        if (text.equals(SINGLE_ITEM_TEXT)) {
            this.servant.finishBankTrip(1);
        }
        if (text.equals(NO_EXTRA_ITEMS_TEXT)) {
            this.servant.finishBankTrip(0);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc() == null || this.servant != null) {
            return;
        }
        Optional<ServantType> typeOptional = ServantType.getByNpcId(event.getNpc().getId());
        typeOptional.ifPresent(type -> {
            Servant servant = new Servant((ServantType)((Object)type));
            servant.setPlugin(this);
            this.setServant(servant);
        });
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        switch (event.getKey()) {
            case "onlyBuildingMode": {
                if (this.config.onlyInBuildingMode() && !this.playerOwnedHouse.isBuildingMode()) {
                    this.removeAll();
                    break;
                }
                this.renderAll();
                break;
            }
            case "showItemCount": {
                if (this.config.showItemCount()) {
                    this.renderItemCounter();
                    break;
                }
                this.removeItemCounter();
                break;
            }
            case "showBankTripTimer": {
                if (this.config.showBankTripTimer()) {
                    this.renderBankTripTimer();
                    break;
                }
                this.removeBankTripTimer(true);
                break;
            }
            case "showTripsUntilPayment": {
                if (this.config.showTripsUntilPayment()) {
                    this.renderTripsUntilPayment();
                    break;
                }
                this.removeTripsUntilPayment();
            }
        }
    }

    public void renderItemCounter() {
        if (!this.config.showItemCount() || this.config.onlyInBuildingMode() && !this.playerOwnedHouse.isBuildingMode()) {
            return;
        }
        this.removeItemCounter();
        if (this.servant.getItemAmountHeld() <= 0) {
            return;
        }
        this.itemCounter = new ItemCounter(this, this.servant, this.itemManager);
        this.infoBoxManager.addInfoBox((InfoBox)this.itemCounter);
    }

    private void removeItemCounter() {
        if (this.itemCounter == null) {
            return;
        }
        this.infoBoxManager.removeInfoBox((InfoBox)this.itemCounter);
        this.itemCounter = null;
    }

    public void startBankTripTimer() {
        if (this.servant == null) {
            return;
        }
        this.bankTripTimer = new BankTripTimer(this, this.servant, this.itemManager);
        this.renderBankTripTimer();
    }

    private void renderBankTripTimer() {
        if (!this.config.showBankTripTimer() || this.config.onlyInBuildingMode() && !this.playerOwnedHouse.isBuildingMode()) {
            return;
        }
        if (this.bankTripTimer == null) {
            return;
        }
        this.removeBankTripTimer(true);
        this.infoBoxManager.addInfoBox((InfoBox)this.bankTripTimer);
    }

    private void removeBankTripTimer(boolean preserveTimer) {
        if (this.bankTripTimer == null) {
            return;
        }
        this.infoBoxManager.removeInfoBox((InfoBox)this.bankTripTimer);
        if (!preserveTimer) {
            this.bankTripTimer = null;
        }
    }

    public void renderTripsUntilPayment() {
        if (!this.config.showTripsUntilPayment() || this.config.onlyInBuildingMode() && !this.playerOwnedHouse.isBuildingMode()) {
            return;
        }
        this.removeTripsUntilPayment();
        if (this.servant.getTripsUntilPayment() <= 0) {
            return;
        }
        this.tripsUntilPaymentCounter = new TripsUntilPaymentCounter(this, this.servant, this.itemManager);
        this.infoBoxManager.addInfoBox((InfoBox)this.tripsUntilPaymentCounter);
    }

    private void removeTripsUntilPayment() {
        if (this.tripsUntilPaymentCounter == null) {
            return;
        }
        this.infoBoxManager.removeInfoBox((InfoBox)this.tripsUntilPaymentCounter);
        this.tripsUntilPaymentCounter = null;
    }

    public void renderAll() {
        this.renderItemCounter();
        this.renderBankTripTimer();
        this.renderTripsUntilPayment();
    }

    private void removeAll() {
        this.removeItemCounter();
        this.removeBankTripTimer(true);
        this.removeTripsUntilPayment();
    }

    public PlayerOwnedHouse getPlayerOwnedHouse() {
        return this.playerOwnedHouse;
    }

    public DialogManager getDialogManager() {
        return this.dialogManager;
    }

    public Servant getServant() {
        return this.servant;
    }

    public void setServant(Servant servant) {
        this.servant = servant;
    }

    public boolean isSendingItemsBack() {
        return this.sendingItemsBack;
    }

    public void setSendingItemsBack(boolean sendingItemsBack) {
        this.sendingItemsBack = sendingItemsBack;
    }

    public boolean isBankTimerReset() {
        return this.bankTimerReset;
    }

    public void setBankTimerReset(boolean bankTimerReset) {
        this.bankTimerReset = bankTimerReset;
    }
}

