/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui.inputs;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.ui.TextButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public abstract class TaskInput
extends JPanel {
    protected final int PREFERRED_INPUT_HEIGHT = 16;
    protected GoalTrackerPlugin plugin;
    private Runnable updater;
    private JPanel inputRow;

    TaskInput(GoalTrackerPlugin plugin, String title) {
        super(new GridBagLayout());
        this.plugin = plugin;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.ipady = 8;
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        titleLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        titleLabel.setBorder(new EmptyBorder(2, 8, 0, 8));
        JPanel titleContainer = new JPanel(new BorderLayout());
        titleContainer.add((Component)titleLabel, "West");
        this.add((Component)titleContainer, constraints);
        ++constraints.gridy;
        this.inputRow = new JPanel(new BorderLayout());
        this.inputRow.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        TextButton addButton = new TextButton("Add");
        addButton.onClick(e -> this.onSubmit());
        this.inputRow.add((Component)addButton, "East");
        this.add((Component)this.inputRow, constraints);
        ++constraints.gridy;
    }

    protected abstract void onSubmit();

    public TaskInput onUpdate(Runnable updater) {
        this.updater = updater;
        return this;
    }

    protected abstract void reset();

    public Runnable getUpdater() {
        return this.updater;
    }

    public JPanel getInputRow() {
        return this.inputRow;
    }
}

