/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui.inputs;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.SkillXpTask;
import com.toofifty.goaltracker.goal.factory.SkillXpTaskFactory;
import com.toofifty.goaltracker.ui.ComboBox;
import com.toofifty.goaltracker.ui.inputs.TaskInput;
import java.awt.Component;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.FlatTextField;

public class SkillXpTaskInput
extends TaskInput {
    private final Goal goal;
    private final FlatTextField xpField;
    private final ComboBox<Skill> skillField;
    private final Pattern numberPattern = Pattern.compile("^(?:\\d+)?$");
    private final Pattern mPattern = Pattern.compile("^(?:\\d+m)?$", 2);
    private final Pattern kPattern = Pattern.compile("^(?:\\d+k)?$", 2);
    private String xpFieldValue = "13034431";

    public SkillXpTaskInput(GoalTrackerPlugin plugin, Goal goal) {
        super(plugin, "Skill XP");
        this.goal = goal;
        this.xpField = new FlatTextField();
        this.xpField.setBorder((Border)new EmptyBorder(0, 8, 0, 8));
        this.xpField.getTextField().setHorizontalAlignment(4);
        this.xpField.setText(this.xpFieldValue);
        this.xpField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.xpField.getDocument().addDocumentListener(e -> SwingUtilities.invokeLater(() -> {
            String value = this.xpField.getText();
            if (this.mPattern.matcher(value).find()) {
                this.xpFieldValue = value = value.replace("m", "000000");
                this.xpField.setText(this.xpFieldValue);
            }
            if (this.kPattern.matcher(value).find()) {
                this.xpFieldValue = value = value.replace("k", "000");
                this.xpField.setText(this.xpFieldValue);
            }
            if (!this.numberPattern.matcher(value).find()) {
                this.xpField.setText(this.xpFieldValue);
                return;
            }
            if (Integer.parseInt(value) > 200000000) {
                this.xpField.setText("200000000");
                value = "200000000";
            }
            this.xpFieldValue = value;
        }));
        this.xpField.setPreferredSize(new Dimension(92, 16));
        this.getInputRow().add((Component)this.xpField, "Center");
        this.skillField = new ComboBox<Skill>((T[])Skill.values());
        this.getInputRow().add(this.skillField, "West");
    }

    @Override
    protected void onSubmit() {
        if (this.xpField.getText().isEmpty()) {
            return;
        }
        SkillXpTask task = new SkillXpTaskFactory(this.plugin, this.goal).create((Skill)this.skillField.getSelectedItem(), Integer.parseInt(this.xpField.getText()));
        this.goal.add(task);
        this.getUpdater().run();
        this.reset();
    }

    @Override
    protected void reset() {
        this.xpFieldValue = "13034431";
        this.xpField.setText(this.xpFieldValue);
        this.skillField.setSelectedIndex(0);
    }
}

