/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui.inputs;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.SkillLevelTask;
import com.toofifty.goaltracker.goal.factory.SkillLevelTaskFactory;
import com.toofifty.goaltracker.ui.ComboBox;
import com.toofifty.goaltracker.ui.inputs.TaskInput;
import java.awt.Component;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.FlatTextField;

public class SkillLevelTaskInput
extends TaskInput {
    private Goal goal;
    private FlatTextField levelField;
    private String levelFieldValue = "99";
    private ComboBox<Skill> skillField;
    private Pattern numberPattern = Pattern.compile("^(?:\\d{1,2})?$");

    public SkillLevelTaskInput(GoalTrackerPlugin plugin, Goal goal) {
        super(plugin, "Skill level");
        this.goal = goal;
        this.levelField = new FlatTextField();
        this.levelField.setBorder((Border)new EmptyBorder(0, 8, 0, 8));
        this.levelField.getTextField().setHorizontalAlignment(4);
        this.levelField.setText(this.levelFieldValue);
        this.levelField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.levelField.getDocument().addDocumentListener(e -> SwingUtilities.invokeLater(() -> {
            String value = this.levelField.getText();
            if (!this.numberPattern.matcher(value).find()) {
                this.levelField.setText(this.levelFieldValue);
                return;
            }
            this.levelFieldValue = value;
        }));
        this.levelField.setPreferredSize(new Dimension(92, 16));
        this.getInputRow().add((Component)this.levelField, "Center");
        this.skillField = new ComboBox<Skill>((T[])Skill.values());
        this.getInputRow().add(this.skillField, "West");
    }

    @Override
    protected void onSubmit() {
        if (this.levelField.getText().isEmpty()) {
            return;
        }
        SkillLevelTask task = new SkillLevelTaskFactory(this.plugin, this.goal).create((Skill)this.skillField.getSelectedItem(), Integer.parseInt(this.levelField.getText()));
        this.goal.add(task);
        this.getUpdater().run();
        this.reset();
    }

    @Override
    protected void reset() {
        this.levelFieldValue = "99";
        this.levelField.setText(this.levelFieldValue);
        this.skillField.setSelectedIndex(0);
    }
}

