/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui.inputs;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.QuestTask;
import com.toofifty.goaltracker.goal.factory.QuestTaskFactory;
import com.toofifty.goaltracker.ui.ComboBox;
import com.toofifty.goaltracker.ui.inputs.TaskInput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.runelite.api.Quest;

public class QuestTaskInput
extends TaskInput {
    private final Goal goal;
    private final ComboBox<Quest> questField;

    public QuestTaskInput(GoalTrackerPlugin plugin, Goal goal) {
        super(plugin, "Quest");
        this.goal = goal;
        List<Quest> quests = Arrays.asList(Quest.values());
        quests.sort(Comparator.comparing(quest -> quest.getName().replaceFirst("^(A|The) ", "")));
        this.questField = new ComboBox<Quest>(quests);
        this.questField.setFormatter(Quest::getName);
        this.getInputRow().add(this.questField, "Center");
    }

    @Override
    protected void onSubmit() {
        QuestTask task = new QuestTaskFactory(this.plugin, this.goal).create((Quest)this.questField.getSelectedItem());
        this.goal.add(task);
        this.getUpdater().run();
        this.reset();
    }

    @Override
    protected void reset() {
        this.questField.setSelectedIndex(0);
    }
}

