/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui.inputs;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.ManualTask;
import com.toofifty.goaltracker.goal.factory.ManualTaskFactory;
import com.toofifty.goaltracker.ui.inputs.TaskInput;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.FlatTextField;

public class ManualTaskInput
extends TaskInput {
    private FlatTextField titleField;
    private Goal goal;

    public ManualTaskInput(GoalTrackerPlugin plugin, Goal goal) {
        super(plugin, "Quick add");
        this.goal = goal;
        this.titleField = new FlatTextField();
        this.titleField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.titleField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ManualTaskInput.this.titleField.getText().length() > 0) {
                    ManualTaskInput.this.onSubmit();
                }
            }
        });
        this.getInputRow().add((Component)this.titleField, "Center");
    }

    @Override
    protected void onSubmit() {
        if (this.titleField.getText().isEmpty()) {
            return;
        }
        ManualTask task = new ManualTaskFactory(this.plugin, this.goal).create(this.titleField.getText(), false);
        this.goal.add(task);
        this.getUpdater().run();
        this.reset();
    }

    @Override
    protected void reset() {
        this.titleField.setText("");
        this.titleField.requestFocusInWindow();
    }
}

