/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui.inputs;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.ItemTask;
import com.toofifty.goaltracker.goal.factory.ItemTaskFactory;
import com.toofifty.goaltracker.ui.TextButton;
import com.toofifty.goaltracker.ui.inputs.TaskInput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.FlatTextField;

public class ItemTaskInput
extends TaskInput {
    private final Goal goal;
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final FlatTextField quantityField = new FlatTextField();
    private final TextButton searchItemButton = new TextButton("Search...");
    private final JLabel selectedItemLabel = new JLabel();
    private final JPanel selectedItemPanel = new JPanel(new BorderLayout());
    private final Pattern numberPattern = Pattern.compile("^(?:\\d+)?$");
    private final Pattern mPattern = Pattern.compile("^(?:\\d+m)?$", 2);
    private final Pattern kPattern = Pattern.compile("^(?:\\d+k)?$", 2);
    private String quantityFieldValue = "1";
    private ItemComposition selectedItem;
    private final TextButton clearItemButton = new TextButton("X").setMainColor(ColorScheme.PROGRESS_ERROR_COLOR).onClick(e -> this.clearSelectedItem());

    public ItemTaskInput(GoalTrackerPlugin plugin, Goal goal) {
        super(plugin, "Item");
        this.goal = goal;
        this.itemManager = plugin.getItemManager();
        this.clientThread = plugin.getClientThread();
        this.searchItemButton.onClick(e -> {
            if (plugin.getClient().getGameState() != GameState.LOGGED_IN) {
                JOptionPane.showMessageDialog(this, "You must be logged in to choose items", "UwU", 0);
                return;
            }
            plugin.getItemSearch().tooltipText("Choose an item").onItemSelected(this::setSelectedItem).build();
        });
        this.getInputRow().add((Component)this.searchItemButton, "West");
        this.quantityField.setBorder((Border)new EmptyBorder(0, 8, 0, 8));
        this.quantityField.getTextField().setHorizontalAlignment(4);
        this.quantityField.setText(this.quantityFieldValue);
        this.quantityField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.quantityField.getDocument().addDocumentListener(e -> SwingUtilities.invokeLater(() -> {
            String value = this.quantityField.getText();
            if (this.mPattern.matcher(value).find()) {
                this.quantityFieldValue = value = value.replace("m", "000000");
                this.quantityField.setText(this.quantityFieldValue);
            }
            if (this.kPattern.matcher(value).find()) {
                this.quantityFieldValue = value = value.replace("k", "000");
                this.quantityField.setText(this.quantityFieldValue);
            }
            if (!this.numberPattern.matcher(value).find()) {
                this.quantityField.setText(this.quantityFieldValue);
                return;
            }
            this.quantityFieldValue = value;
        }));
        this.quantityField.setPreferredSize(new Dimension(92, 16));
        this.getInputRow().add((Component)this.quantityField, "Center");
        this.selectedItemPanel.setBorder(new EmptyBorder(0, 8, 0, 8));
        this.selectedItemPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.selectedItemPanel.add((Component)this.selectedItemLabel, "Center");
        this.selectedItemPanel.add((Component)this.clearItemButton, "East");
    }

    private void setSelectedItem(int rawId) {
        this.clientThread.invokeLater(() -> {
            int id = this.itemManager.canonicalize(rawId);
            this.selectedItem = this.itemManager.getItemComposition(id);
            this.selectedItemLabel.setText(this.selectedItem.getName());
            this.getInputRow().remove(this.searchItemButton);
            this.getInputRow().add((Component)this.selectedItemPanel, "West");
            this.revalidate();
            this.repaint();
        });
    }

    @Override
    protected void onSubmit() {
        if (this.selectedItem == null || this.quantityField.getText().isEmpty()) {
            return;
        }
        ItemTask task = new ItemTaskFactory(this.plugin, this.goal).create(this.selectedItem.getId(), this.selectedItem.getName(), Integer.parseInt(this.quantityField.getText()));
        this.goal.add(task);
        this.getUpdater().run();
        this.reset();
    }

    private void clearSelectedItem() {
        this.selectedItem = null;
        this.getInputRow().remove(this.selectedItemPanel);
        this.getInputRow().add((Component)this.searchItemButton, "West");
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void reset() {
        this.clearSelectedItem();
        this.quantityFieldValue = "1";
        this.quantityField.setText(this.quantityFieldValue);
    }
}

