/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class TextButton
extends JLabel {
    private Color mainColor = ColorScheme.PROGRESS_COMPLETE_COLOR;

    public TextButton(String text, Color mainColor) {
        this(text);
        this.setMainColor(mainColor);
    }

    public TextButton(String text) {
        super(text);
        this.setFont(FontManager.getRunescapeSmallFont());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(0, 8, 0, 8));
        this.setForeground(this.mainColor);
    }

    public TextButton(String text, Consumer<MouseEvent> clickListener) {
        this(text);
        this.onClick(clickListener);
    }

    public TextButton setMainColor(Color mainColor) {
        this.mainColor = mainColor;
        this.setForeground(mainColor);
        return this;
    }

    public TextButton onClick(final Consumer<MouseEvent> clickListener) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                clickListener.accept(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TextButton.this.setForeground(TextButton.this.mainColor.darker());
                TextButton.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TextButton.this.setForeground(TextButton.this.mainColor);
                TextButton.this.setCursor(new Cursor(0));
            }
        });
        return this;
    }

    public TextButton narrow() {
        this.setBorder(new EmptyBorder(0, 2, 0, 2));
        return this;
    }
}

