/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.ui.TextButton;
import com.toofifty.goaltracker.ui.inputs.ItemTaskInput;
import com.toofifty.goaltracker.ui.inputs.ManualTaskInput;
import com.toofifty.goaltracker.ui.inputs.QuestTaskInput;
import com.toofifty.goaltracker.ui.inputs.SkillLevelTaskInput;
import com.toofifty.goaltracker.ui.inputs.SkillXpTaskInput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class NewTaskPanel
extends JPanel {
    private final GoalTrackerPlugin plugin;
    private final Goal goal;
    private Runnable updater;
    private TextButton moreOptionsButton;
    private JPanel moreOptionsPanel;

    NewTaskPanel(GoalTrackerPlugin plugin, Goal goal) {
        this.plugin = plugin;
        this.goal = goal;
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.ipady = 8;
        this.add((Component)new ManualTaskInput(plugin, goal).onUpdate(() -> this.updater.run()), constraints);
        ++constraints.gridy;
        this.moreOptionsButton = new TextButton("+ More options");
        this.moreOptionsButton.setBorder(new EmptyBorder(4, 8, 0, 8));
        this.moreOptionsButton.onClick(e -> {
            if (this.moreOptionsPanel.isVisible()) {
                this.hideMoreOptions();
            } else {
                this.showMoreOptions();
            }
        });
        JPanel moreOptionsButtonPanel = new JPanel(new BorderLayout());
        moreOptionsButtonPanel.add((Component)this.moreOptionsButton, "West");
        this.add((Component)moreOptionsButtonPanel, constraints);
        ++constraints.gridy;
        this.createMoreOptionsPanel();
        this.add((Component)this.moreOptionsPanel, constraints);
    }

    private void hideMoreOptions() {
        this.moreOptionsButton.setText("+ More options");
        this.moreOptionsButton.setMainColor(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.moreOptionsPanel.setVisible(false);
    }

    private void showMoreOptions() {
        this.moreOptionsButton.setText("- More options");
        this.moreOptionsButton.setMainColor(ColorScheme.PROGRESS_ERROR_COLOR);
        this.moreOptionsPanel.setVisible(true);
    }

    private void createMoreOptionsPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.ipady = 8;
        this.moreOptionsPanel = new JPanel(new GridBagLayout());
        this.moreOptionsPanel.setVisible(false);
        this.moreOptionsPanel.add((Component)new SkillLevelTaskInput(this.plugin, this.goal).onUpdate(() -> this.updater.run()), constraints);
        ++constraints.gridy;
        this.moreOptionsPanel.add((Component)new SkillXpTaskInput(this.plugin, this.goal).onUpdate(() -> this.updater.run()), constraints);
        ++constraints.gridy;
        this.moreOptionsPanel.add((Component)new QuestTaskInput(this.plugin, this.goal).onUpdate(() -> this.updater.run()), constraints);
        ++constraints.gridy;
        this.moreOptionsPanel.add((Component)new ItemTaskInput(this.plugin, this.goal).onUpdate(() -> this.updater.run()), constraints);
        ++constraints.gridy;
    }

    public void onUpdate(Runnable updater) {
        this.updater = updater;
    }
}

