/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import com.toofifty.goaltracker.ReorderableList;
import com.toofifty.goaltracker.ui.ListItemPanel;
import com.toofifty.goaltracker.ui.Refreshable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class ListPanel<T>
extends JScrollPane
implements Refreshable {
    private final JPanel wrapperPanel = new JPanel(new BorderLayout());
    private final JPanel listPanel = new JPanel(new GridBagLayout());
    private final ReorderableList<T> reorderableList;
    private final Function<T, ListItemPanel<T>> renderItem;
    private final Map<T, ListItemPanel<T>> itemPanelMap = new HashMap<T, ListItemPanel<T>>();
    private int gap = 2;
    private String placeholder = "Nothing interesting happens.";

    ListPanel(ReorderableList<T> reorderableList, Function<T, ListItemPanel<T>> renderItem) {
        this.reorderableList = reorderableList;
        this.renderItem = renderItem;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.listPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.wrapperPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.wrapperPanel.add((Component)this.listPanel, "North");
        this.setBorder(new EmptyBorder(4, 4, 4 - this.gap, 4));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.getVerticalScrollBar().setPreferredSize(new Dimension(12, 0));
        this.getVerticalScrollBar().setBorder(new EmptyBorder(0, 4, 0, 0));
        this.setViewportView(this.wrapperPanel);
        this.setHorizontalScrollBarPolicy(31);
        this.tryBuildList();
        this.tryBuildPlaceholder();
    }

    public void setGap(int gap) {
        this.gap = gap;
        this.setBorder(new EmptyBorder(4, 4, 4 - gap, 4));
        this.tryBuildList();
        this.tryBuildPlaceholder();
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        this.tryBuildList();
        this.tryBuildPlaceholder();
    }

    private List<ListItemPanel<T>> buildItemPanels() {
        return this.reorderableList.getAll().stream().map(this::buildItemPanel).collect(Collectors.toList());
    }

    @Override
    public void refresh() {
        for (Component component : this.listPanel.getComponents()) {
            if (!(component instanceof Refreshable)) continue;
            ((Refreshable)((Object)component)).refresh();
        }
    }

    private ListItemPanel<T> buildItemPanel(T item) {
        if (this.itemPanelMap.containsKey(item)) {
            return this.itemPanelMap.get(item);
        }
        ListItemPanel<T> itemPanel = this.renderItem.apply(item);
        itemPanel.setRunOnReorder(() -> {
            this.tryBuildList();
            this.tryBuildPlaceholder();
        });
        this.itemPanelMap.put(item, itemPanel);
        return itemPanel;
    }

    private GridBagConstraints getConstraints() {
        return this.getConstraints(0);
    }

    private GridBagConstraints getConstraints(int gridy) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridy = gridy;
        constraints.gridx = 0;
        constraints.insets = new Insets(0, 0, this.gap, 0);
        return constraints;
    }

    private void refreshChildMenus() {
        for (Component component : this.listPanel.getComponents()) {
            if (!(component instanceof ListItemPanel)) continue;
            ((ListItemPanel)component).refreshMenu();
        }
    }

    private void tryBuildPlaceholder() {
        if (this.reorderableList.getAll().isEmpty()) {
            this.listPanel.removeAll();
            JLabel placeholderLabel = new JLabel(this.placeholder);
            placeholderLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            JPanel placeholderPanel = new JPanel();
            placeholderPanel.add(placeholderLabel);
            this.listPanel.add((Component)placeholderPanel, this.getConstraints());
        }
    }

    public void tryBuildList() {
        if (!this.reorderableList.getAll().isEmpty()) {
            this.listPanel.removeAll();
            GridBagConstraints constraints = this.getConstraints();
            this.buildItemPanels().forEach(component -> {
                this.listPanel.add((Component)component, constraints);
                ++constraints.gridy;
            });
            this.refreshChildMenus();
            this.revalidate();
        }
    }
}

