/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import com.toofifty.goaltracker.ReorderableList;
import com.toofifty.goaltracker.ui.Refreshable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class ListItemPanel<T>
extends JPanel
implements Refreshable {
    private final JMenuItem moveUp = new JMenuItem("Move up");
    private final JMenuItem moveDown = new JMenuItem("Move down");
    private final JMenuItem moveToTop = new JMenuItem("Move to top");
    private final JMenuItem moveToBottom = new JMenuItem("Move to bottom");
    private final JMenuItem removeTask = new JMenuItem("Remove");
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final ReorderableList<T> list;
    private final T item;
    private Runnable runOnReorder;

    ListItemPanel(ReorderableList<T> list, T item) {
        super(new BorderLayout());
        this.list = list;
        this.item = item;
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.moveUp.addActionListener(e -> {
            list.move(item, -1);
            this.runOnReorder.run();
        });
        this.moveDown.addActionListener(e -> {
            list.move(item, 1);
            this.runOnReorder.run();
        });
        this.moveToTop.addActionListener(e -> {
            list.moveToTop(item);
            this.runOnReorder.run();
        });
        this.moveToBottom.addActionListener(e -> {
            list.moveToBottom(item);
            this.runOnReorder.run();
        });
        this.removeTask.addActionListener(e -> {
            list.remove(item);
            this.runOnReorder.run();
        });
        this.popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setComponentPopupMenu(this.popupMenu);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        for (Component component : this.getComponents()) {
            component.setBackground(bg);
        }
    }

    @Override
    public void refresh() {
        this.refreshMenu();
        for (Component component : this.getComponents()) {
            if (!(component instanceof Refreshable)) continue;
            ((Refreshable)((Object)component)).refresh();
        }
    }

    public void refreshMenu() {
        this.popupMenu.removeAll();
        if (!this.list.isFirst(this.item).booleanValue()) {
            this.popupMenu.add(this.moveUp);
        }
        if (!this.list.isLast(this.item).booleanValue()) {
            this.popupMenu.add(this.moveDown);
        }
        if (!this.list.isFirst(this.item).booleanValue()) {
            this.popupMenu.add(this.moveToTop);
        }
        if (!this.list.isLast(this.item).booleanValue()) {
            this.popupMenu.add(this.moveToBottom);
        }
        this.popupMenu.add(this.removeTask);
    }

    @Override
    public ListItemPanel<T> add(Component comp) {
        super.add(comp, "Center");
        return this;
    }

    public ListItemPanel<T> onClick(final Consumer<MouseEvent> clickListener) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                clickListener.accept(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ListItemPanel.this.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ListItemPanel.this.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        return this;
    }

    public void setRunOnReorder(Runnable runOnReorder) {
        this.runOnReorder = runOnReorder;
    }
}

