/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import com.toofifty.goaltracker.GoalManager;
import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.ui.GoalItemContent;
import com.toofifty.goaltracker.ui.GoalPanel;
import com.toofifty.goaltracker.ui.ListItemPanel;
import com.toofifty.goaltracker.ui.ListPanel;
import com.toofifty.goaltracker.ui.Refreshable;
import com.toofifty.goaltracker.ui.TextButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

public class GoalTrackerPanel
extends PluginPanel
implements Refreshable {
    private final GoalTrackerPlugin plugin;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final ListPanel<Goal> goalListPanel;

    public GoalTrackerPanel(GoalTrackerPlugin plugin) {
        super(false);
        this.plugin = plugin;
        GoalManager goalManager = plugin.getGoalManager();
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)new TextButton("+ Add goal", e -> this.view(goalManager.createGoal())).narrow(), "East");
        JLabel title = new JLabel();
        title.setText("Goal Tracker");
        title.setForeground(Color.WHITE);
        title.setFont(FontManager.getRunescapeBoldFont());
        titlePanel.add((Component)title, "West");
        this.goalListPanel = new ListPanel<Goal>(goalManager, goal -> new ListItemPanel<Goal>(goalManager, (Goal)goal).onClick(e -> this.view((Goal)goal)).add(new GoalItemContent(plugin, (Goal)goal)));
        this.goalListPanel.setGap(0);
        this.goalListPanel.setPlaceholder("Add a new goal using the button above");
        this.mainPanel.add((Component)titlePanel, "North");
        this.mainPanel.add(this.goalListPanel, "Center");
        this.home();
    }

    public void view(Goal goal) {
        this.removeAll();
        GoalPanel goalPanel = new GoalPanel(this.plugin, goal, this::home);
        this.add(goalPanel, "Center");
        goalPanel.refresh();
        this.revalidate();
        this.repaint();
    }

    public void home() {
        this.removeAll();
        this.add(this.mainPanel, "Center");
        this.goalListPanel.tryBuildList();
        this.goalListPanel.refresh();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void refresh() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof Refreshable)) continue;
            ((Refreshable)((Object)component)).refresh();
        }
        this.goalListPanel.refresh();
    }
}

