/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.TaskUIStatusManager;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.ManualTask;
import com.toofifty.goaltracker.goal.Task;
import com.toofifty.goaltracker.goal.TaskType;
import com.toofifty.goaltracker.ui.EditableInput;
import com.toofifty.goaltracker.ui.ListItemPanel;
import com.toofifty.goaltracker.ui.ListPanel;
import com.toofifty.goaltracker.ui.NewTaskPanel;
import com.toofifty.goaltracker.ui.Refreshable;
import com.toofifty.goaltracker.ui.TaskItemContent;
import com.toofifty.goaltracker.ui.TextButton;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class GoalPanel
extends JPanel
implements Refreshable {
    private EditableInput descriptionInput;
    private ListPanel<Task> taskListPanel;
    private Goal goal;

    GoalPanel(GoalTrackerPlugin plugin, Goal goal, Runnable closeListener) {
        this.goal = goal;
        this.setLayout(new BorderLayout());
        this.descriptionInput = new EditableInput(goal::setDescription);
        TextButton backButton = new TextButton("< Back", ColorScheme.PROGRESS_ERROR_COLOR);
        backButton.onClick(e -> closeListener.run());
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)this.descriptionInput, "Center");
        headerPanel.add((Component)backButton, "West");
        headerPanel.setBorder(new EmptyBorder(0, 0, 8, 0));
        this.add((Component)headerPanel, "North");
        this.taskListPanel = new ListPanel<Task>(goal, task -> {
            ListItemPanel<Task> taskPanel = new ListItemPanel<Task>(goal, (Task)task);
            taskPanel.add(new TaskItemContent(plugin, (Task)task));
            taskPanel.setBorder(new EmptyBorder(2, 4, 2, 4));
            if (task.getType() == TaskType.MANUAL) {
                taskPanel.onClick(e -> {
                    ((ManualTask)task).toggle();
                    if (task.check().isCompleted()) {
                        plugin.notifyTask((Task)task);
                    }
                    task.save();
                    TaskUIStatusManager.getInstance().refresh((Task)task);
                });
            }
            return taskPanel;
        });
        this.taskListPanel.setGap(0);
        this.taskListPanel.setPlaceholder("No tasks added yet");
        this.add(this.taskListPanel, "Center");
        NewTaskPanel newTaskPanel = new NewTaskPanel(plugin, goal);
        newTaskPanel.onUpdate(() -> {
            this.taskListPanel.tryBuildList();
            this.taskListPanel.refresh();
            plugin.setValidateAll(true);
        });
        this.add((Component)newTaskPanel, "South");
    }

    @Override
    public void refresh() {
        this.descriptionInput.setValue(this.goal.getDescription());
        this.taskListPanel.refresh();
    }
}

