/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.TaskUIStatusManager;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.ui.Refreshable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class GoalItemContent
extends JPanel
implements Refreshable {
    private final JLabel title = new JLabel();
    private final JLabel progress = new JLabel();
    private final GoalTrackerPlugin plugin;
    private final Goal goal;

    GoalItemContent(GoalTrackerPlugin plugin, Goal goal) {
        super(new BorderLayout());
        this.plugin = plugin;
        this.goal = goal;
        this.add((Component)this.title, "West");
        this.add((Component)this.progress, "East");
        TaskUIStatusManager.getInstance().addRefresher(goal, this::refresh);
    }

    @Override
    public void refresh() {
        Boolean isComplete = this.goal.isComplete();
        Boolean isInProgress = this.goal.isInProgress();
        Color color = isComplete != false ? ColorScheme.PROGRESS_COMPLETE_COLOR : (isInProgress != false ? ColorScheme.PROGRESS_INPROGRESS_COLOR : ColorScheme.PROGRESS_ERROR_COLOR);
        this.title.setText(this.goal.getDescription());
        this.title.setForeground(color);
        this.progress.setText(this.goal.getComplete().size() + "/" + this.goal.getTasks().size());
        this.progress.setForeground(color);
    }
}

