/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import com.toofifty.goaltracker.ui.TextButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.FlatTextField;

public class EditableInput
extends JPanel {
    private static final Border INPUT_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    private final FlatTextField inputField = new FlatTextField();
    private final TextButton save = new TextButton("Save").narrow();
    private final TextButton cancel = new TextButton("Cancel", ColorScheme.PROGRESS_ERROR_COLOR).narrow();
    private final TextButton edit = new TextButton("Edit", ColorScheme.LIGHT_GRAY_COLOR).narrow();
    private Consumer<String> saveAction;
    private String localValue = "";

    EditableInput(Consumer<String> saveAction) {
        this.saveAction = saveAction;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(INPUT_BOTTOM_BORDER);
        JPanel actions = new JPanel(new BorderLayout(3, 0));
        actions.setBorder(new EmptyBorder(0, 0, 0, 8));
        actions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.save.setVisible(false);
        this.save.onClick(e -> this.save());
        this.cancel.setVisible(false);
        this.cancel.onClick(e -> this.cancel());
        this.edit.onClick(e -> {
            this.inputField.setEditable(true);
            this.updateActions(true);
        });
        actions.add((Component)this.save, "East");
        actions.add((Component)this.cancel, "West");
        actions.add((Component)this.edit, "Center");
        this.inputField.setText(this.localValue);
        this.inputField.setBorder(null);
        this.inputField.setEditable(false);
        this.inputField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.inputField.setPreferredSize(new Dimension(50, 24));
        this.inputField.getTextField().setForeground(Color.WHITE);
        this.inputField.getTextField().setBorder(new EmptyBorder(0, 8, 0, 0));
        this.inputField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EditableInput.this.save();
                } else if (e.getKeyCode() == 27) {
                    EditableInput.this.cancel();
                }
            }
        });
        this.add((Component)this.inputField, "Center");
        this.add((Component)actions, "East");
    }

    private void save() {
        this.localValue = this.inputField.getText();
        this.saveAction.accept(this.localValue);
        this.inputField.setEditable(false);
        this.updateActions(false);
        this.requestFocusInWindow();
    }

    private void cancel() {
        this.inputField.setEditable(false);
        this.inputField.setText(this.localValue);
        this.updateActions(false);
        this.requestFocusInWindow();
    }

    private void updateActions(boolean saveAndCancel) {
        this.save.setVisible(saveAndCancel);
        this.cancel.setVisible(saveAndCancel);
        this.edit.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.inputField.getTextField().requestFocusInWindow();
            this.inputField.getTextField().selectAll();
        }
    }

    public void setValue(String value) {
        this.localValue = value;
        if (this.localValue == null) {
            this.localValue = "";
        }
        this.inputField.setText(this.localValue);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.inputField.getTextField().addMouseListener(l);
    }
}

