/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.Text;

class ComboBoxListRenderer<T>
implements ListCellRenderer<T> {
    private Function<T, String> formatter;

    ComboBoxListRenderer(Function<T, String> formatter) {
        this.formatter = formatter;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T o, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(new EmptyBorder(0, 4, 0, 4));
        JLabel label = new JLabel();
        if (this.formatter != null) {
            label.setText(this.formatter.apply(o));
        } else {
            label.setText(o instanceof Enum ? Text.titleCase((Enum)((Enum)o)) : o.toString());
        }
        container.add((Component)label, "West");
        if (isSelected) {
            container.setBackground(ColorScheme.DARK_GRAY_COLOR);
            label.setForeground(Color.WHITE);
        }
        return container;
    }
}

