/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.goal;

import com.google.gson.JsonObject;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.TaskStatus;
import com.toofifty.goaltracker.goal.TaskType;
import java.awt.image.BufferedImage;

public abstract class Task {
    protected TaskStatus result = TaskStatus.NOT_STARTED;
    private Goal goal;
    private boolean hasBeenNotified = false;

    public Task(Goal goal) {
        this.goal = goal;
    }

    public void hasBeenNotified(Boolean hasBeenNotified) {
        this.hasBeenNotified = hasBeenNotified;
    }

    public boolean hasBeenNotified() {
        return this.hasBeenNotified;
    }

    public TaskStatus check() {
        return this.result;
    }

    public abstract String toString();

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType().getName());
        json.addProperty("previous_result", this.result.getName());
        json.addProperty("has_been_notified", Boolean.valueOf(this.hasBeenNotified));
        return this.addSerializedProperties(json);
    }

    public abstract TaskType getType();

    protected abstract JsonObject addSerializedProperties(JsonObject var1);

    public boolean hasIcon() {
        return this.getIcon() != null;
    }

    public abstract BufferedImage getIcon();

    public void save() {
        this.goal.save();
    }

    public void setResult(TaskStatus result) {
        this.result = result;
    }

    public TaskStatus getResult() {
        return this.result;
    }

    public Goal getGoal() {
        return this.goal;
    }
}

