/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.goal;

import com.google.gson.JsonObject;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.Task;
import com.toofifty.goaltracker.goal.TaskStatus;
import com.toofifty.goaltracker.goal.TaskType;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;

public class SkillLevelTask
extends Task {
    private final Client client;
    private final SkillIconManager skillIconManager;
    private Skill skill;
    private int level;

    public SkillLevelTask(Client client, SkillIconManager skillIconManager, Goal goal) {
        super(goal);
        this.client = client;
        this.skillIconManager = skillIconManager;
    }

    @Override
    public TaskStatus check() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return this.result;
        }
        this.result = this.client.getRealSkillLevel(this.skill) >= this.level ? TaskStatus.COMPLETED : TaskStatus.NOT_STARTED;
        return this.result;
    }

    @Override
    public String toString() {
        return this.level + " " + this.skill.getName();
    }

    @Override
    public TaskType getType() {
        return TaskType.SKILL_LEVEL;
    }

    @Override
    protected JsonObject addSerializedProperties(JsonObject json) {
        json.addProperty("skill", this.skill.getName());
        json.addProperty("level", (Number)this.level);
        return json;
    }

    @Override
    public BufferedImage getIcon() {
        return this.skillIconManager.getSkillImage(this.skill);
    }

    public void setSkill(Skill skill) {
        this.skill = skill;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

