/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.goal;

import com.google.gson.JsonObject;
import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.Task;
import com.toofifty.goaltracker.goal.TaskStatus;
import com.toofifty.goaltracker.goal.TaskType;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.client.util.ImageUtil;

public class QuestTask
extends Task {
    private static final BufferedImage QUEST_ICON = ImageUtil.loadImageResource(GoalTrackerPlugin.class, (String)"/quest_icon.png");
    private final Client client;
    private Quest quest;

    public QuestTask(Client client, Goal goal) {
        super(goal);
        this.client = client;
    }

    @Override
    public TaskStatus check() {
        if (this.client.getGameState() != GameState.LOGGED_IN || !this.client.isClientThread()) {
            return this.result;
        }
        this.result = this.getTaskStatus(this.quest.getState(this.client));
        return this.result;
    }

    private TaskStatus getTaskStatus(QuestState questState) {
        switch (questState) {
            case IN_PROGRESS: {
                return TaskStatus.IN_PROGRESS;
            }
            case FINISHED: {
                return TaskStatus.COMPLETED;
            }
        }
        return TaskStatus.NOT_STARTED;
    }

    @Override
    public String toString() {
        return this.quest.getName();
    }

    @Override
    public TaskType getType() {
        return TaskType.QUEST;
    }

    @Override
    protected JsonObject addSerializedProperties(JsonObject json) {
        json.addProperty("quest_id", (Number)this.quest.getId());
        return json;
    }

    @Override
    public BufferedImage getIcon() {
        return QUEST_ICON;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public void setQuest(Quest quest) {
        this.quest = quest;
    }
}

