/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.goal;

import com.google.gson.JsonObject;
import com.toofifty.goaltracker.ItemCache;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.Task;
import com.toofifty.goaltracker.goal.TaskStatus;
import com.toofifty.goaltracker.goal.TaskType;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;

public class ItemTask
extends Task {
    private final Client client;
    private final ItemManager itemManager;
    private final ItemCache itemCache;
    private BufferedImage cachedIcon;
    private int quantity;
    private int acquired = 0;
    private int itemId;
    private String itemName;

    public ItemTask(Client client, ItemManager itemManager, ItemCache itemCache, Goal goal) {
        super(goal);
        this.client = client;
        this.itemManager = itemManager;
        this.itemCache = itemCache;
    }

    @Override
    public TaskStatus check() {
        this.acquired = Math.min(this.itemCache.getTotalQuantity(this.itemId), this.quantity);
        return this.acquired >= this.quantity ? TaskStatus.COMPLETED : (this.acquired > 0 ? TaskStatus.IN_PROGRESS : TaskStatus.NOT_STARTED);
    }

    @Override
    public String toString() {
        if (this.quantity == 1) {
            return this.itemName;
        }
        if (this.acquired > 0 && this.acquired < this.quantity) {
            return String.format("%,d", this.acquired) + "/" + String.format("%,d", this.quantity) + " x " + this.itemName;
        }
        return String.format("%,d", this.quantity) + " x " + this.itemName;
    }

    @Override
    public TaskType getType() {
        return TaskType.ITEM;
    }

    @Override
    protected JsonObject addSerializedProperties(JsonObject json) {
        json.addProperty("item_id", (Number)this.itemId);
        json.addProperty("item_name", this.itemName);
        json.addProperty("quantity", (Number)this.quantity);
        json.addProperty("acquired", (Number)this.acquired);
        return json;
    }

    @Override
    public BufferedImage getIcon() {
        if (this.cachedIcon != null) {
            return this.cachedIcon;
        }
        if (!this.client.isClientThread()) {
            return null;
        }
        this.cachedIcon = this.itemManager.getImage(this.itemId);
        return this.cachedIcon;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setAcquired(int acquired) {
        this.acquired = acquired;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemName() {
        return this.itemName;
    }
}

