/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker.goal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.toofifty.goaltracker.GoalManager;
import com.toofifty.goaltracker.ReorderableList;
import com.toofifty.goaltracker.goal.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Goal
implements ReorderableList<Task> {
    private String description = "New goal";
    private int displayOrder = -1;
    private List<Task> tasks = new ArrayList<Task>();
    private GoalManager goalManager;

    public Goal(GoalManager goalManager) {
        this.goalManager = goalManager;
    }

    public List<Task> getIncomplete() {
        return this.filterBy(task -> !task.check().isCompleted());
    }

    private List<Task> filterBy(Predicate<Task> predicate) {
        return this.tasks.stream().filter(predicate).collect(Collectors.toList());
    }

    public Boolean isComplete() {
        return this.getComplete().size() == this.getTasks().size();
    }

    public List<Task> getComplete() {
        return this.filterBy(task -> task.check().isCompleted());
    }

    public Boolean isInProgress() {
        return this.getComplete().size() > 0;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("description", this.description);
        json.addProperty("display_order", (Number)this.displayOrder);
        JsonArray items = new JsonArray();
        this.tasks.forEach(task -> items.add((JsonElement)task.serialize()));
        json.add("items", (JsonElement)items);
        return json;
    }

    public void save() {
        this.goalManager.save();
    }

    @Override
    public List<Task> getAll() {
        return this.tasks;
    }

    @Override
    public void add(Task task) {
        this.tasks.add(task);
    }

    @Override
    public void remove(Task task) {
        this.tasks.remove(task);
    }

    @Override
    public void move(Task task, int offset) {
        int index = this.tasks.indexOf(task);
        this.tasks.remove(task);
        this.tasks.add(index + offset, task);
    }

    @Override
    public void moveToTop(Task task) {
        this.tasks.remove(task);
        this.tasks.add(0, task);
    }

    @Override
    public void moveToBottom(Task task) {
        this.tasks.remove(task);
        this.tasks.add(task);
    }

    @Override
    public Boolean isFirst(Task task) {
        return this.tasks.get(0) == task;
    }

    @Override
    public Boolean isLast(Task task) {
        return this.tasks.get(this.tasks.size() - 1) == task;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }
}

