/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker;

import com.google.inject.Provides;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.Task;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;

public class TaskUIStatusManager {
    private static TaskUIStatusManager instance;
    private final Map<Task, Runnable> taskRefreshers = new WeakHashMap<Task, Runnable>();
    private final Map<Goal, Runnable> goalRefreshers = new WeakHashMap<Goal, Runnable>();

    public static TaskUIStatusManager getInstance() {
        if (instance == null) {
            instance = new TaskUIStatusManager();
        }
        return instance;
    }

    public void addRefresher(Task task, Runnable refresher) {
        this.getTaskRefreshers().put(task, refresher);
    }

    public void addRefresher(Goal goal, Runnable refresher) {
        this.getGoalRefreshers().put(goal, refresher);
    }

    public void refresh(Task task) {
        SwingUtilities.invokeLater(() -> {
            if (this.taskRefreshers.containsKey(task)) {
                this.taskRefreshers.get(task).run();
            } else {
                System.out.println("Missing task refresher for " + task.toString());
            }
            if (this.goalRefreshers.containsKey(task.getGoal())) {
                this.goalRefreshers.get(task.getGoal()).run();
            } else {
                System.out.println("Missing goal refresher for " + task.toString());
            }
        });
    }

    @Provides
    public TaskUIStatusManager getTaskUIStatusManager() {
        return TaskUIStatusManager.getInstance();
    }

    public Map<Task, Runnable> getTaskRefreshers() {
        return this.taskRefreshers;
    }

    public Map<Goal, Runnable> getGoalRefreshers() {
        return this.goalRefreshers;
    }
}

