/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.toofifty.goaltracker.GoalTrackerConfig;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Item;

@Singleton
public class ItemCache {
    private Map<Integer, Item[]> inventories;
    private Map<Integer, Integer> itemTotals;
    @Inject
    private GoalTrackerConfig config;
    @Inject
    private Gson gson;

    public void save() {
        this.config.goalTrackerItemCache(this.gson.toJson(this.inventories));
    }

    public void load() {
        Map<Object, Object> savedInventories = (Map<Object, Object>)this.gson.fromJson(this.config.goalTrackerItemCache(), new TypeToken<Map<Integer, Item[]>>(){}.getType());
        this.inventories = savedInventories != null ? savedInventories : new HashMap<Integer, Item[]>();
        this.calculateItemTotals();
    }

    public void calculateItemTotals() {
        this.itemTotals = new HashMap<Integer, Integer>();
        for (int inventory : this.inventories.keySet()) {
            for (Item item : this.inventories.get(inventory)) {
                this.itemTotals.put(item.getId(), this.itemTotals.getOrDefault(item.getId(), 0) + item.getQuantity());
            }
        }
    }

    public void update(int inventoryID, Item[] contents) {
        this.inventories.put(inventoryID, contents);
        this.calculateItemTotals();
    }

    public int getTotalQuantity(int itemId) {
        return this.itemTotals.getOrDefault(itemId, 0);
    }
}

