/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker;

import com.google.inject.Provides;
import com.toofifty.goaltracker.GoalManager;
import com.toofifty.goaltracker.GoalTrackerConfig;
import com.toofifty.goaltracker.ItemCache;
import com.toofifty.goaltracker.TaskUIStatusManager;
import com.toofifty.goaltracker.goal.ItemTask;
import com.toofifty.goaltracker.goal.QuestTask;
import com.toofifty.goaltracker.goal.SkillLevelTask;
import com.toofifty.goaltracker.goal.SkillXpTask;
import com.toofifty.goaltracker.goal.Task;
import com.toofifty.goaltracker.goal.TaskType;
import com.toofifty.goaltracker.ui.GoalTrackerPanel;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.chatbox.ChatboxItemSearch;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Goal Tracker", description="Keep track of your goals and complete them automatically")
public class GoalTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GoalTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatboxItemSearch itemSearch;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemCache itemCache;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private GoalTrackerConfig config;
    private GoalManager goalManager;
    private NavigationButton uiNavigationButton;
    private GoalTrackerPanel goalTrackerPanel;
    private boolean validateAll = true;

    @Provides
    GoalTrackerConfig getGoalTrackerConfig(ConfigManager configManager) {
        return (GoalTrackerConfig)configManager.getConfig(GoalTrackerConfig.class);
    }

    protected void startUp() {
        this.goalManager = new GoalManager(this);
        this.goalManager.load();
        this.itemCache.load();
        AsyncBufferedImage icon = this.itemManager.getImage(11203);
        this.goalTrackerPanel = new GoalTrackerPanel(this);
        this.uiNavigationButton = NavigationButton.builder().tooltip("Goal Tracker").icon((BufferedImage)icon).priority(7).panel((PluginPanel)this.goalTrackerPanel).build();
        this.clientToolbar.addNavigation(this.uiNavigationButton);
    }

    protected void shutDown() {
        this.goalManager.save();
        this.itemCache.save();
        this.clientToolbar.removeNavigation(this.uiNavigationButton);
    }

    @Subscribe
    public void onSessionOpen(SessionOpen event) {
        this.goalManager.load();
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        List skillLevelTasks = this.goalManager.getAllIncompleteTasksOfType(TaskType.SKILL_LEVEL);
        for (SkillLevelTask task : skillLevelTasks) {
            if (event.getSkill() != task.getSkill() || event.getLevel() < task.getLevel()) continue;
            this.notifyTask(task);
            TaskUIStatusManager.getInstance().refresh(task);
        }
        List skillXpTasks = this.goalManager.getAllIncompleteTasksOfType(TaskType.SKILL_XP);
        for (SkillXpTask task : skillXpTasks) {
            if (event.getSkill() != task.getSkill() || event.getXp() < task.getXp()) continue;
            this.notifyTask(task);
            TaskUIStatusManager.getInstance().refresh(task);
        }
    }

    public void notifyTask(Task task) {
        if (this.client.getGameState() != GameState.LOGGED_IN || task.hasBeenNotified()) {
            return;
        }
        System.out.println("Notify: [Goal Tracker] You have completed a task: " + task.toString() + "!");
        String message = "[Goal Tracker] You have completed a task: " + task.toString() + "!";
        String formattedMessage = new ChatMessageBuilder().append(ColorScheme.PROGRESS_COMPLETE_COLOR, message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).name("Goal Tracker").runeLiteFormattedMessage(formattedMessage).build());
        task.hasBeenNotified(true);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.validateAll = true;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.validateAll) {
            return;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.validateAll = false;
        this.goalTrackerPanel.refresh();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && event.getMessage().contains("Quest complete")) {
            List questTasks = this.goalManager.getAllIncompleteTasksOfType(TaskType.QUEST);
            for (QuestTask task : questTasks) {
                if (!task.check().isCompleted()) continue;
                this.notifyTask(task);
                TaskUIStatusManager.getInstance().refresh(task);
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        this.itemCache.update(event.getContainerId(), event.getItemContainer().getItems());
        List itemTasks = this.goalManager.getAllIncompleteTasksOfType(TaskType.ITEM);
        for (ItemTask task : itemTasks) {
            if (task.getResult().isCompleted()) continue;
            if (task.check().isCompleted()) {
                this.notifyTask(task);
            }
            TaskUIStatusManager.getInstance().refresh(task);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public SkillIconManager getSkillIconManager() {
        return this.skillIconManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public ChatboxItemSearch getItemSearch() {
        return this.itemSearch;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public ItemCache getItemCache() {
        return this.itemCache;
    }

    public GoalTrackerConfig getConfig() {
        return this.config;
    }

    public GoalManager getGoalManager() {
        return this.goalManager;
    }

    public void setValidateAll(boolean validateAll) {
        this.validateAll = validateAll;
    }
}

