/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.goaltracker;

import com.toofifty.goaltracker.GoalSerializer;
import com.toofifty.goaltracker.GoalTrackerConfig;
import com.toofifty.goaltracker.GoalTrackerPlugin;
import com.toofifty.goaltracker.ReorderableList;
import com.toofifty.goaltracker.goal.Goal;
import com.toofifty.goaltracker.goal.SkillLevelTask;
import com.toofifty.goaltracker.goal.Task;
import com.toofifty.goaltracker.goal.TaskType;
import java.util.ArrayList;
import java.util.List;

public class GoalManager
implements ReorderableList<Goal> {
    private List<Goal> goals;
    private GoalTrackerConfig config;
    private GoalSerializer goalSerializer;

    public GoalManager(GoalTrackerPlugin plugin) {
        this.config = plugin.getConfig();
        this.goalSerializer = new GoalSerializer(plugin);
    }

    public void save() {
        this.config.goalTrackerData(this.goalSerializer.serialize(this.goals));
        System.out.println("Saved " + this.goals.size() + " goals");
    }

    public void load() {
        try {
            this.goals = this.goalSerializer.deserialize(this, this.config.goalTrackerData());
        }
        catch (Exception e) {
            this.goals = new ArrayList<Goal>();
        }
        System.out.println("Loaded " + this.goals.size() + " goals");
    }

    public Goal createGoal() {
        Goal goal = new Goal(this);
        this.add(goal);
        return goal;
    }

    public List<SkillLevelTask> getAllSkillTasks() {
        ArrayList<SkillLevelTask> tasks = new ArrayList<SkillLevelTask>();
        for (Goal goal : this.goals) {
            for (Task task : goal.getAll()) {
                if (!(task instanceof SkillLevelTask)) continue;
                tasks.add((SkillLevelTask)task);
            }
        }
        return tasks;
    }

    public <T> List<T> getAllIncompleteTasksOfType(TaskType type) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Goal goal : this.goals) {
            for (Task task : goal.getAll()) {
                if (task.getResult().isCompleted() || task.getType() != type) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }

    @Override
    public List<Goal> getAll() {
        return this.goals;
    }

    @Override
    public void add(Goal goal) {
        this.goals.add(goal);
    }

    @Override
    public void remove(Goal goal) {
        this.goals.remove(goal);
    }

    @Override
    public void move(Goal goal, int offset) {
        int index = this.goals.indexOf(goal);
        this.goals.remove(goal);
        this.goals.add(index + offset, goal);
    }

    @Override
    public void moveToTop(Goal goal) {
        this.goals.remove(goal);
        this.goals.add(0, goal);
    }

    @Override
    public void moveToBottom(Goal goal) {
        this.goals.remove(goal);
        this.goals.add(goal);
    }

    @Override
    public Boolean isFirst(Goal goal) {
        return this.goals.get(0) == goal;
    }

    @Override
    public Boolean isLast(Goal goal) {
        return this.goals.get(this.goals.size() - 1) == goal;
    }
}

