/*
 * Decompiled with CFR 0.152.
 */
package com.gimptracker;

import com.gimptracker.ConnectionManager;
import com.gimptracker.DataBuilder;
import com.gimptracker.DataItem;
import com.gimptracker.DataLoot;
import com.gimptracker.DataManager;
import com.gimptracker.DataSkill;
import com.gimptracker.GimpTrackerConfig;
import com.gimptracker.GimpTrackerPanel;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.loottracker.LootRecordType;

@PluginDescriptor(name="GIMP Tracker", description="Tracks players movement/inventory/skills etc..", tags={"tracker", "gimp"}, enabledByDefault=true)
public class GimpTrackerPlugin
extends Plugin
implements ActionListener,
ConnectionManager.ConnectionListener {
    private static final String VERSION = "1.0.2";
    private static final String CONFIG_GROUP = "gimptracker";
    private WorldPoint previousTile = new WorldPoint(0, 0, 0);
    private int previousHealth = 99;
    private int previousPrayer = 99;
    private int previousEnergy = 100;
    private int tickCountSinceLogged = 0;
    public GameState previousGameState = GameState.UNKNOWN;
    public GameState previousGameState2 = GameState.UNKNOWN;
    public JButton connectButton;
    public JLabel connectButtonLabel;
    public JButton debugButton;
    private NavigationButton navButton;
    private DataManager dataManager;
    private ConnectionManager connectionManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private GimpTrackerConfig config;
    @Inject
    private ClientToolbar clientToolbar;

    @Provides
    private GimpTrackerConfig getConfig(ConfigManager configManager) {
        return (GimpTrackerConfig)configManager.getConfig(GimpTrackerConfig.class);
    }

    @Override
    public void onConnectionStatusChanged(ConnectionManager.ConnectionStatus status) {
        this.updateConnectButton();
        switch (status) {
            case DISCONNECTED: {
                this.dataManager.resetPackets();
            }
        }
    }

    @Override
    public void onConnectionErrorChanged(ConnectionManager.ConnectionError status) {
        this.updateConnectButton();
        switch (status) {
            case AUTHORIZED: {
                this.queueFullPacket();
            }
        }
    }

    public void queueFullPacket() {
        WorldPoint point = this.client.getLocalPlayer().getWorldLocation();
        this.dataManager.getCurrentPacket().setName(this.client.getLocalPlayer().getName());
        this.dataManager.getCurrentPacket().setPosition(point.getX(), point.getY(), point.getPlane());
        int flags = 1031;
        this.dataManager.getCurrentPacket().setWorld(this.client.getWorld());
        this.queueAccountType();
        if (this.config.sendInventory()) {
            flags |= 8;
            this.queueInventoryData();
        }
        if (this.config.sendSkill()) {
            flags |= 0x10;
            this.queueSkillData();
        }
        if (this.config.sendEquipment()) {
            flags |= 0x20;
            this.queueEquipmentData();
        }
        if (this.config.sendHealth()) {
            flags |= 0x40;
            this.dataManager.getCurrentPacket().setHealth(this.previousHealth);
        }
        if (this.config.sendPrayer()) {
            flags |= 0x80;
            this.dataManager.getCurrentPacket().setPrayer(this.previousPrayer);
        }
        if (this.config.sendEnergy()) {
            flags |= 0x100;
            this.dataManager.getCurrentPacket().setEnergy(this.previousEnergy);
        }
        this.dataManager.getCurrentPacket().setGoalFlags(flags);
    }

    public void queueInventoryData() {
        this.clientThread.invokeLater(() -> {
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            Item[] items = null;
            if (inventory != null) {
                items = inventory.getItems();
            }
            this.dataManager.getCurrentPacket().setInventory(items);
        });
    }

    public void queueSkillData() {
        this.clientThread.invokeLater(() -> {
            DataSkill[] skills = new DataSkill[Skill.values().length - 1];
            for (int i = 0; i < Skill.values().length - 1; ++i) {
                int xp = this.client.getSkillExperience(Skill.values()[i]);
                skills[i] = new DataSkill(i, xp);
            }
            this.dataManager.getCurrentPacket().setSkills(skills);
        });
    }

    public void queueEquipmentData() {
        this.clientThread.invokeLater(() -> {
            ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
            Item[] items = null;
            if (equipment != null) {
                items = equipment.getItems();
            }
            this.dataManager.getCurrentPacket().setEquipment(items);
        });
    }

    public void queueAccountType() {
        this.clientThread.invokeLater(() -> {
            int accType = this.client.getVar(1777);
            this.dataManager.getCurrentPacket().setAccountType(accType);
        });
    }

    public void updateClient(boolean connect) {
        if (!this.dataManager.getCurrentPacket().hasReachedGoal()) {
            return;
        }
        this.dataManager.getCurrentPacket().resetGoal();
        DataBuilder builder = this.dataManager.finalizePacket();
        if (builder.wasChanged) {
            String evt = connect ? "RL_CONNECT_STATE" : "RL_UPDATE_STATE";
            this.connectionManager.sendData(evt, builder.build());
        }
    }

    private void updateConnectButton() {
        switch (this.connectionManager.getConnectionStatus()) {
            case CONNECTING: {
                this.connectButton.setText("Connecting...");
                this.connectButton.setEnabled(true);
                break;
            }
            case DISCONNECTING: {
                this.connectButton.setText("Disconnecting...");
                this.connectButton.setEnabled(false);
                break;
            }
            case CONNECTED: {
                this.connectButton.setEnabled(true);
                this.connectButton.setText("Disconnect");
                break;
            }
            case DISCONNECTED: {
                this.connectButton.setEnabled(this.client.getGameState() == GameState.LOGGED_IN);
                if (this.connectionManager.isConnecting()) {
                    this.connectButton.setText("Connecting...");
                    break;
                }
                this.connectButton.setText("Connect");
                break;
            }
        }
        this.connectButtonLabel.setText(ConnectionManager.connectionErrorStrings[this.connectionManager.getConnectionError().ordinal()]);
        switch (this.connectionManager.connectionError) {
            case NONE: {
                this.connectButtonLabel.setForeground(Color.WHITE);
                break;
            }
            case AUTHORIZED: {
                this.connectButtonLabel.setForeground(Color.GREEN);
                break;
            }
            case UNAUTHORIZED: 
            case TIMED_OUT: 
            case BAD_URL: 
            case LOST_CONNECTION: {
                this.connectButtonLabel.setForeground(Color.RED);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JButton btn = (JButton)arg0.getSource();
        if (btn == this.connectButton) {
            if (this.connectionManager.isConnecting() || this.connectionManager.isConnected()) {
                this.connectionManager.disconnect();
            } else {
                this.connectionManager.connect();
            }
        } else if (btn == this.debugButton) {
            this.clientThread.invokeLater(() -> {
                int accType = this.client.getVar(1777);
                System.out.println(accType);
            });
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            if (this.config.sendInventory()) {
                this.queueInventoryData();
            }
        } else if (event.getContainerId() == InventoryID.EQUIPMENT.getId() && this.config.sendEquipment()) {
            this.queueEquipmentData();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (this.config.sendSkill()) {
            this.queueSkillData();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.dataManager.getCurrentPacket().setWorld(this.client.getWorld());
            if (this.previousGameState == GameState.LOADING && this.previousGameState2 == GameState.LOGGING_IN) {
                this.tickCountSinceLogged = 0;
                this.updateConnectButton();
            }
        } else if (event.getGameState() == GameState.CONNECTION_LOST || event.getGameState() == GameState.LOGIN_SCREEN) {
            this.connectionManager.disconnect();
        }
        this.previousGameState2 = this.previousGameState;
        this.previousGameState = event.getGameState();
    }

    public void postLogInTick() {
        this.tickCountSinceLogged = -1;
        if (this.config.connectOnLogin()) {
            this.connectionManager.connect();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        switch (event.getKey()) {
            case "password": {
                this.connectionManager.setSocketBuilderOptions(true, -1, this.config.password());
            }
        }
    }

    protected void startUp() throws Exception {
        this.connectionManager = new ConnectionManager(this);
        this.dataManager = new DataManager();
        this.connectionManager.init();
        this.connectionManager.addConnectionListener(this);
        this.connectButton = new JButton("Connect");
        this.connectButton.addActionListener(this);
        this.connectButtonLabel = new JLabel("");
        GimpTrackerPanel panel = (GimpTrackerPanel)((Object)this.injector.getInstance(GimpTrackerPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"/gimptracker.png");
        this.navButton = NavigationButton.builder().tooltip("GIMP Tracker").icon(icon).priority(1).panel((PluginPanel)panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.connectionManager.disconnect();
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) throws Exception {
        if (this.config.sendData() && this.connectionManager.isConnected() && this.connectionManager.isAuthorized()) {
            this.updateClient(this.connectionManager.isFirstPacket());
        }
        if (this.tickCountSinceLogged >= 1) {
            this.postLogInTick();
        }
        if (this.tickCountSinceLogged >= 0) {
            ++this.tickCountSinceLogged;
        }
        WorldPoint currentTile = this.client.getLocalPlayer().getWorldLocation();
        int currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        int currentEnergy = this.client.getEnergy();
        if (currentTile.getX() != this.previousTile.getX() || currentTile.getY() != this.previousTile.getY() || currentTile.getPlane() != this.previousTile.getPlane()) {
            this.dataManager.getCurrentPacket().setPosition(currentTile.getX(), currentTile.getY(), currentTile.getPlane());
            this.previousTile = currentTile;
        }
        if (currentHealth != this.previousHealth) {
            this.previousHealth = currentHealth;
            if (this.config.sendHealth()) {
                this.dataManager.getCurrentPacket().setHealth(currentHealth);
            }
        }
        if (currentPrayer != this.previousPrayer) {
            this.previousPrayer = currentPrayer;
            if (this.config.sendPrayer()) {
                this.dataManager.getCurrentPacket().setPrayer(currentPrayer);
            }
        }
        if (currentEnergy != this.previousEnergy) {
            this.previousEnergy = currentEnergy;
            if (this.config.sendEnergy()) {
                this.dataManager.getCurrentPacket().setEnergy(currentEnergy);
            }
        }
    }

    private static Collection<DataItem> toGameItems(Collection<ItemStack> items) {
        return items.stream().map(item -> new DataItem(item.getId(), item.getQuantity())).collect(Collectors.toList());
    }

    void addLoot(@NonNull String name, int combatLevel, LootRecordType type, Object metadata, Collection<ItemStack> items) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Collection<DataItem> drop_items = GimpTrackerPlugin.toGameItems(items);
        DataItem[] item = drop_items.toArray(new DataItem[drop_items.size()]);
        DataLoot loot = new DataLoot((Integer)metadata, combatLevel, name, type, "" + Instant.now().toEpochMilli());
        loot.items = item;
        this.dataManager.getCurrentPacket().addLoot(loot);
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        NPC npc = npcLootReceived.getNpc();
        Collection items = npcLootReceived.getItems();
        String name = npc.getName();
        int combat = npc.getCombatLevel();
        this.addLoot(name, combat, LootRecordType.NPC, npc.getId(), items);
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        Player player = playerLootReceived.getPlayer();
        Collection items = playerLootReceived.getItems();
        String name = player.getName();
        int combat = player.getCombatLevel();
        this.addLoot(name, combat, LootRecordType.PLAYER, null, items);
    }

    public WorldPoint getPreviousTile() {
        return this.previousTile;
    }

    public int getPreviousHealth() {
        return this.previousHealth;
    }

    public int getPreviousPrayer() {
        return this.previousPrayer;
    }

    public int getPreviousEnergy() {
        return this.previousEnergy;
    }

    public int getTickCountSinceLogged() {
        return this.tickCountSinceLogged;
    }

    public GameState getPreviousGameState() {
        return this.previousGameState;
    }

    public GameState getPreviousGameState2() {
        return this.previousGameState2;
    }

    public JButton getConnectButton() {
        return this.connectButton;
    }

    public JLabel getConnectButtonLabel() {
        return this.connectButtonLabel;
    }

    public JButton getDebugButton() {
        return this.debugButton;
    }

    public NavigationButton getNavButton() {
        return this.navButton;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GimpTrackerConfig getConfig() {
        return this.config;
    }

    public ClientToolbar getClientToolbar() {
        return this.clientToolbar;
    }
}

