/*
 * Decompiled with CFR 0.152.
 */
package com.gimptracker;

import com.gimptracker.DataItem;
import com.gimptracker.DataLoot;
import com.gimptracker.DataSkill;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedList;
import net.runelite.api.Item;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

public class DataBuilder {
    public static final int INVENTORY_SIZE = 28;
    public static final int EQUIPMENT_SIZE = 14;
    public static final int INVALID_WORLD = -1;
    public String name = null;
    public int world = -1;
    public WorldPoint pos = null;
    public DataItem[] inventory = null;
    public DataSkill[] skills = null;
    public DataItem[] equipment = null;
    public LinkedList<DataLoot> loot = new LinkedList();
    int health = -1;
    int prayer = -1;
    int energy = -1;
    int accountType = -1;
    public JsonObject data = null;
    public int goalProgress = 0;
    public int goal = 0;
    public boolean wasChanged = false;

    public DataBuilder() {
    }

    public DataBuilder(DataBuilder other) {
        this.health = other.health;
        this.prayer = other.prayer;
        this.energy = other.energy;
        this.name = other.name;
        this.world = other.world;
        this.pos = other.pos;
        this.accountType = other.accountType;
        if (other.inventory != null) {
            this.inventory = new DataItem[28];
            System.arraycopy(other.inventory, 0, this.inventory, 0, other.inventory.length);
        }
        if (other.skills != null) {
            this.skills = new DataSkill[Skill.values().length - 1];
            System.arraycopy(other.skills, 0, this.skills, 0, other.skills.length);
        }
        if (other.equipment != null) {
            this.equipment = new DataItem[14];
            System.arraycopy(other.equipment, 0, this.equipment, 0, other.equipment.length);
        }
        if (other.loot != null && other.loot.size() > 0) {
            this.loot = new LinkedList();
            for (int i = 0; i < other.loot.size(); ++i) {
                DataLoot otherLoot = other.loot.get(i);
                DataLoot newLoot = new DataLoot();
                newLoot.metadata = otherLoot.metadata;
                newLoot.combatLevel = otherLoot.combatLevel;
                newLoot.name = otherLoot.name;
                newLoot.timestamp = otherLoot.timestamp;
                newLoot.items = new DataItem[otherLoot.items.length];
                System.arraycopy(otherLoot.items, 0, newLoot.items, 0, otherLoot.items.length);
                this.loot.add(newLoot);
            }
        }
        if (other.data != null) {
            this.data = other.data.deepCopy();
        }
        this.wasChanged = other.wasChanged;
    }

    public void setHealth(int health) {
        this.setGoalProgressFlag(64);
        this.wasChanged = true;
        this.health = health;
    }

    public void setPrayer(int prayer) {
        this.setGoalProgressFlag(128);
        this.wasChanged = true;
        this.prayer = prayer;
    }

    public void setEnergy(int energy) {
        this.setGoalProgressFlag(256);
        this.wasChanged = true;
        this.energy = energy;
    }

    public void setName(String name) {
        this.setGoalProgressFlag(1);
        this.wasChanged = true;
        this.name = name;
    }

    public void setWorld(int world) {
        this.setGoalProgressFlag(2);
        this.wasChanged = true;
        this.world = world;
    }

    public void setAccountType(int accountType) {
        this.setGoalProgressFlag(1024);
        this.wasChanged = true;
        this.accountType = accountType;
    }

    public void setPosition(int x, int y, int plane) {
        this.setGoalProgressFlag(4);
        this.wasChanged = true;
        this.pos = new WorldPoint(x, y, plane);
    }

    public void setInventory(Item[] inventory) {
        this.setGoalProgressFlag(8);
        if (inventory == null) {
            return;
        }
        this.wasChanged = true;
        this.inventory = new DataItem[28];
        for (int i = 0; i < this.inventory.length; ++i) {
            Item item = null;
            if (i < inventory.length) {
                item = inventory[i];
            }
            this.inventory[i] = new DataItem();
            if (item == null) {
                this.inventory[i].id = -1;
                this.inventory[i].quantity = 0;
                continue;
            }
            this.inventory[i].id = item.getId();
            this.inventory[i].quantity = item.getQuantity();
        }
    }

    public void setInventory(DataItem[] inventory) {
        this.setGoalProgressFlag(8);
        if (inventory == null) {
            return;
        }
        this.wasChanged = true;
        this.inventory = new DataItem[28];
        for (int i = 0; i < this.inventory.length; ++i) {
            DataItem item = null;
            if (i < inventory.length) {
                item = inventory[i];
            }
            this.inventory[i] = new DataItem();
            if (item == null) {
                this.inventory[i].id = -2;
                this.inventory[i].quantity = 0;
                continue;
            }
            this.inventory[i].id = item.id;
            this.inventory[i].quantity = item.quantity;
        }
    }

    public void setEquipment(Item[] equipment) {
        this.setGoalProgressFlag(32);
        if (equipment == null) {
            return;
        }
        this.wasChanged = true;
        this.equipment = new DataItem[14];
        for (int i = 0; i < this.equipment.length; ++i) {
            Item item = null;
            if (i < equipment.length) {
                item = equipment[i];
            }
            this.equipment[i] = new DataItem();
            if (item == null) {
                this.equipment[i].id = -1;
                this.equipment[i].quantity = 0;
                continue;
            }
            this.equipment[i].id = item.getId();
            this.equipment[i].quantity = item.getQuantity();
        }
    }

    public void setEquipment(DataItem[] equipment) {
        this.setGoalProgressFlag(32);
        if (equipment == null) {
            return;
        }
        this.wasChanged = true;
        this.equipment = new DataItem[14];
        for (int i = 0; i < this.equipment.length; ++i) {
            DataItem item = null;
            if (i < equipment.length) {
                item = equipment[i];
            }
            this.equipment[i] = new DataItem();
            if (item == null) {
                this.equipment[i].id = -2;
                this.equipment[i].quantity = 0;
                continue;
            }
            this.equipment[i].id = item.id;
            this.equipment[i].quantity = item.quantity;
        }
    }

    public void setSkills(DataSkill[] skills) {
        this.setGoalProgressFlag(16);
        if (skills == null) {
            return;
        }
        this.wasChanged = true;
        this.skills = skills;
    }

    public void setLoot(LinkedList<DataLoot> loot) {
        this.setGoalProgressFlag(512);
        if (loot == null) {
            return;
        }
        this.wasChanged = true;
        this.loot = loot;
    }

    public void addLoot(DataLoot loot) {
        this.setGoalProgressFlag(512);
        if (loot == null) {
            return;
        }
        this.wasChanged = true;
        this.loot.add(loot);
    }

    public JsonObject build() {
        this.data = new JsonObject();
        if (this.health != -1) {
            this.data.addProperty("health", (Number)this.health);
        }
        if (this.prayer != -1) {
            this.data.addProperty("prayer", (Number)this.prayer);
        }
        if (this.energy != -1) {
            this.data.addProperty("energy", (Number)this.energy);
        }
        if (this.name != null) {
            this.data.addProperty("name", this.name);
        }
        if (this.world != -1) {
            this.data.addProperty("world", (Number)this.world);
        }
        if (this.accountType != -1) {
            this.data.addProperty("accountType", (Number)this.accountType);
        }
        if (this.pos != null) {
            JsonObject jsonPos = new JsonObject();
            jsonPos.addProperty("x", (Number)this.pos.getX());
            jsonPos.addProperty("y", (Number)this.pos.getY());
            jsonPos.addProperty("plane", (Number)this.pos.getPlane());
            this.data.add("pos", (JsonElement)jsonPos);
        }
        JsonObject jsonInventory = new JsonObject();
        if (this.inventory != null) {
            for (int i = 0; i < 28; ++i) {
                if (this.inventory[i].id == -2) continue;
                JsonObject jsonInvSlotData = new JsonObject();
                jsonInvSlotData.addProperty("id", (Number)this.inventory[i].id);
                jsonInvSlotData.addProperty("quantity", (Number)this.inventory[i].quantity);
                jsonInventory.add(String.valueOf(i), (JsonElement)jsonInvSlotData);
            }
            this.data.add("inventory", (JsonElement)jsonInventory);
        }
        JsonObject jsonSkills = new JsonObject();
        if (this.skills != null) {
            for (int i = 0; i < Skill.values().length - 1; ++i) {
                if (this.skills[i].id == -1) continue;
                JsonObject jsonSkillData = new JsonObject();
                jsonSkillData.addProperty("id", (Number)this.skills[i].id);
                jsonSkillData.addProperty("experience", (Number)this.skills[i].experience);
                jsonSkills.add(String.valueOf(i), (JsonElement)jsonSkillData);
            }
            this.data.add("skills", (JsonElement)jsonSkills);
        }
        JsonObject jsonEquipment = new JsonObject();
        if (this.equipment != null) {
            for (int i = 0; i < 14; ++i) {
                if (this.equipment[i].id == -2) continue;
                JsonObject jsonEqpSlotData = new JsonObject();
                jsonEqpSlotData.addProperty("id", (Number)this.equipment[i].id);
                jsonEqpSlotData.addProperty("quantity", (Number)this.equipment[i].quantity);
                jsonEquipment.add(String.valueOf(i), (JsonElement)jsonEqpSlotData);
            }
            this.data.add("equipment", (JsonElement)jsonEquipment);
        }
        JsonArray jsonLootArray = new JsonArray();
        JsonObject jsonLoot = new JsonObject();
        long lootLength = this.loot.size();
        if (this.loot != null && lootLength > 0L) {
            int j = 0;
            while ((long)j < lootLength) {
                DataLoot currentLoot = this.loot.remove();
                jsonLoot.addProperty("metadata", (Number)currentLoot.metadata);
                jsonLoot.addProperty("combatLevel", (Number)currentLoot.combatLevel);
                jsonLoot.addProperty("name", currentLoot.name);
                jsonLoot.addProperty("type", currentLoot.type.name());
                jsonLoot.addProperty("timestamp", currentLoot.timestamp);
                JsonArray jsonLootItems = new JsonArray();
                for (int i = 0; i < currentLoot.items.length; ++i) {
                    JsonObject jsonLootSlotData = new JsonObject();
                    jsonLootSlotData.addProperty("id", (Number)currentLoot.items[i].id);
                    jsonLootSlotData.addProperty("quantity", (Number)currentLoot.items[i].quantity);
                    jsonLootItems.add((JsonElement)jsonLootSlotData);
                }
                jsonLoot.add("items", (JsonElement)jsonLootItems);
                jsonLootArray.add((JsonElement)jsonLoot);
                ++j;
            }
            this.data.add("loot", (JsonElement)jsonLootArray);
        }
        this.wasChanged = false;
        return this.data;
    }

    public JsonObject getBuiltData() {
        return this.data;
    }

    public void setGoalProgressFlag(int dataFlag) {
        this.goalProgress |= dataFlag;
    }

    public void setGoalFlags(int dataFlag) {
        this.goal = dataFlag;
    }

    public boolean hasReachedGoal() {
        return (this.goalProgress & this.goal) == this.goal;
    }

    public void resetGoal() {
        this.goal = 0;
    }

    public boolean equals(Object o) {
        DataBuilder other = (DataBuilder)o;
        return this.health == other.health && this.prayer == other.prayer && this.energy == other.energy && this.name.equals(other.name) && this.world == other.world && this.accountType == other.accountType && this.pos.getX() == other.pos.getX() && this.pos.getY() == other.pos.getY() && this.pos.getPlane() == other.pos.getPlane() && Arrays.equals(this.inventory, other.inventory) && Arrays.equals(this.skills, other.skills) && Arrays.equals(this.equipment, other.equipment) && this.loot.equals(other.loot);
    }

    public class DataFlags {
        public static final int UNDEFINED = 0;
        public static final int NAME = 1;
        public static final int WORLD = 2;
        public static final int POSITION = 4;
        public static final int INVENTORY = 8;
        public static final int SKILLS = 16;
        public static final int EQUIPMENT = 32;
        public static final int HEALTH = 64;
        public static final int PRAYER = 128;
        public static final int ENERGY = 256;
        public static final int LOOT = 512;
        public static final int ACCOUNT_TYPE = 1024;
        public static final int ALL = 1535;
    }

    public class DataInventoryID {
        public static final int NOT_SET = -2;
        public static final int EMPTY = -1;
    }
}

