/*
 * Decompiled with CFR 0.152.
 */
package com.gimptracker;

import com.gimptracker.GimpTrackerPlugin;
import com.gimptracker.SocketEventAuth;
import com.gimptracker.SocketEventConnect;
import com.gimptracker.SocketEventDisconnect;
import com.gimptracker.SocketEventTimeout;
import com.google.gson.JsonObject;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;

public class ConnectionManager {
    public static final String[] connectionStatusStrings = new String[]{"Connecting", "Disconnecting", "Connected", "Disconnected"};
    public static final String[] connectionErrorStrings = new String[]{"", "Authorized", "Unauthorized", "Could not connect to URL", "Invalid URL", "Lost connection"};
    private URI uri = null;
    public IO.Options options = null;
    public Socket socket = null;
    private SocketEventConnect socketConnectEvent;
    private SocketEventDisconnect socketDisconnectEvent;
    private SocketEventTimeout socketTimeoutEvent;
    private SocketEventAuth socketAuthEvent;
    public ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;
    public ConnectionError connectionError = ConnectionError.NONE;
    public ArrayList<ConnectionListener> listeners = new ArrayList();
    public boolean firstPacket = true;
    public boolean authorized = false;
    private GimpTrackerPlugin plugin = null;

    public ConnectionManager(GimpTrackerPlugin plugin) {
        this.plugin = plugin;
    }

    public void setConnectionStatus(ConnectionStatus status) {
        if (status == ConnectionStatus.DISCONNECTED) {
            this.firstPacket = true;
            this.authorized = false;
        }
        this.connectionStatus = status;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onConnectionStatusChanged(status);
        }
    }

    public void setConnectionError(ConnectionError error) {
        if (error == ConnectionError.AUTHORIZED) {
            this.authorized = true;
        }
        this.connectionError = error;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onConnectionErrorChanged(error);
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void init() {
        this.socketConnectEvent = new SocketEventConnect(this.plugin);
        this.socketDisconnectEvent = new SocketEventDisconnect(this.plugin);
        this.socketTimeoutEvent = new SocketEventTimeout(this.plugin);
        this.socketAuthEvent = new SocketEventAuth(this.plugin);
        this.setSocketBuilderOptions(true, -1, this.plugin.getConfig().password());
    }

    public void setSocketBuilderOptions(boolean reconnect, int timeout, String password) {
        this.options = IO.Options.builder().setQuery("system=runelite").setReconnection(reconnect).setTimeout(timeout).setReconnectionDelay(5000L).setAuth(Collections.singletonMap("token", password)).build();
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.connected();
    }

    public boolean isConnecting() {
        return this.socket != null && this.socket.isActive() && !this.socket.connected();
    }

    public boolean connect() {
        this.disconnect();
        try {
            this.uri = URI.create(this.plugin.getConfig().url());
        }
        catch (IllegalArgumentException e) {
            this.setConnectionError(ConnectionError.BAD_URL);
            return false;
        }
        try {
            this.socket = IO.socket(this.uri, this.options);
        }
        catch (RuntimeException e) {
            this.setConnectionError(ConnectionError.BAD_URL);
            return false;
        }
        this.setConnectionError(ConnectionError.NONE);
        this.socket.on("connect", this.socketConnectEvent);
        this.socket.on("disconnect", this.socketDisconnectEvent);
        this.socket.on("connect_error", this.socketTimeoutEvent);
        this.socket.on("authorize", this.socketAuthEvent);
        this.socket.connect();
        this.setConnectionStatus(ConnectionStatus.CONNECTING);
        return true;
    }

    public void disconnect() {
        if (this.socket != null) {
            if (this.socket.connected()) {
                this.setConnectionStatus(ConnectionStatus.DISCONNECTING);
                this.socket.disconnect();
                this.socket.close();
                this.socket = null;
                return;
            }
            this.socket.close();
        }
        this.socket = null;
        this.setConnectionStatus(ConnectionStatus.DISCONNECTED);
    }

    public void sendData(String event, JsonObject json) {
        this.socket.emit(event, json.toString());
        this.firstPacket = false;
    }

    public URI getUri() {
        return this.uri;
    }

    public IO.Options getOptions() {
        return this.options;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public SocketEventConnect getSocketConnectEvent() {
        return this.socketConnectEvent;
    }

    public SocketEventDisconnect getSocketDisconnectEvent() {
        return this.socketDisconnectEvent;
    }

    public SocketEventTimeout getSocketTimeoutEvent() {
        return this.socketTimeoutEvent;
    }

    public SocketEventAuth getSocketAuthEvent() {
        return this.socketAuthEvent;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public ConnectionError getConnectionError() {
        return this.connectionError;
    }

    public ArrayList<ConnectionListener> getListeners() {
        return this.listeners;
    }

    public boolean isFirstPacket() {
        return this.firstPacket;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public GimpTrackerPlugin getPlugin() {
        return this.plugin;
    }

    public static interface ConnectionListener {
        public void onConnectionStatusChanged(ConnectionStatus var1);

        public void onConnectionErrorChanged(ConnectionError var1);
    }

    public static enum ConnectionError {
        NONE,
        AUTHORIZED,
        UNAUTHORIZED,
        TIMED_OUT,
        BAD_URL,
        LOST_CONNECTION,
        MAX;

    }

    public static enum ConnectionStatus {
        CONNECTING,
        DISCONNECTING,
        CONNECTED,
        DISCONNECTED,
        MAX;

    }

    public class SocketEvent {
        public static final String CONNECT = "RL_CONNECT_STATE";
        public static final String UPDATE = "RL_UPDATE_STATE";
    }
}

