/*
 * Decompiled with CFR 0.152.
 */
package com.brooklyn.smartmetronome;

import com.brooklyn.smartmetronome.SmartMetronomeConfig;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Preferences;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Smart Metronome", description="A metronome that automatically ticks when useful", tags={"skilling", "skill", "minigame", "tick", "timers", "1t", "2t", "3t", "hub", "fishing", "sound", "brooklyn"})
public class SmartMetronomePlugin
extends Plugin {
    static final String CONFIG_GROUP = "smartMetronome";
    @Inject
    private Client client;
    @Inject
    private SmartMetronomeConfig config;
    private int previousID;
    private int previousPlane;
    private int tickCounter = 0;
    private boolean inventoryItems;
    private boolean shouldTickTock;
    private boolean shouldTock = false;
    private final int[] herbSet = new int[]{249, 255, 251, 253};
    private final int[] vambSet = new int[]{1065, 2487, 2489, 2491};
    private final Map<Integer, Integer> ABYSSAL_SIRE_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> CERB_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> COMMANDER_ZILYANA_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> CORP_BEAST_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> DKS_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> GENERAL_GRAARDOR_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> GIANT_MOLE_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> KRIL_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> KALPHITE_QUEEN_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> KREE_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> SARACHNIS_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> THERMY_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> WINTERTODT_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> ZALCANO_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> BLAST_FURNACE_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> BRIMHAVEN_AGILITY_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> PYRAMID_PLUNDER_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> CATACOMBS_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> STRONGHOLD_CAVE_REGIONS = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> FREMENNIK_SLAYER_REGIONS = new HashMap<Integer, Integer>();
    private static final Set<Integer> ALCHEMICAL_HYDRA_REGIONS = ImmutableSet.of((Object)5536);
    private static final Set<Integer> BARROWS_REGIONS = ImmutableSet.of((Object)14231);
    private static final Set<Integer> GROTESQUE_GUARDIANS_REGIONS = ImmutableSet.of((Object)6727);
    private static final Set<Integer> NIGHTMARE_REGIONS = ImmutableSet.of((Object)15515);
    private static final Set<Integer> SKOTIZO_REGIONS = ImmutableSet.of((Object)6810);
    private static final Set<Integer> VORKATH_REGIONS = ImmutableSet.of((Object)9023);
    private static final Set<Integer> ZULRAH_REGIONS = ImmutableSet.of((Object)9007);
    private static final Set<Integer> FIGHT_CAVE_REGIONS = ImmutableSet.of((Object)9551);
    private static final Set<Integer> GAUNTLET_REGIONS = ImmutableSet.of((Object)7512, (Object)7768);
    private static final Set<Integer> HALLOWED_SEPULCHRE_REGIONS = ImmutableSet.of((Object)8797, (Object)9051, (Object)9052, (Object)9053, (Object)9054, (Object)9309, (Object[])new Integer[]{9563, 9821, 10074, 10075, 10077});
    private static final Set<Integer> INFERNO_REGIONS = ImmutableSet.of((Object)9043);
    private static final Set<Integer> PEST_CONTROL_REGIONS = ImmutableSet.of((Object)10536);
    private static final Set<Integer> TITHE_FARM_REGIONS = ImmutableSet.of((Object)7222);
    private static final Set<Integer> VOLCANIC_MINE_REGIONS = ImmutableSet.of((Object)15263, (Object)15262);
    private static final Set<Integer> SLAYER_TOWER_REGIONS = ImmutableSet.of((Object)13623, (Object)13723);
    private static final Set<Integer> MUTE_REGIONS = ImmutableSet.of((Object)12106, (Object)12107, (Object)11412, (Object)11413, (Object)11414, (Object)10901, (Object[])new Integer[]{10899, 10900, 10645, 13619, 13874, 13875, 13876, 14130, 14488, 14232, 14487, 5139, 11586, 11587, 11841, 11843, 11845, 12097, 12098, 12099, 12100, 12101, 9808, 9807, 9552, 10063, 10064, 5535, 5280, 5279, 5023, 5278, 14387, 14388, 14132, 10537, 7492, 7748, 9565, 13366, 13367, 13368, 13622, 13624, 13878, 13879, 13880, 13466, 13467, 13722, 13978, 13979, 6710, 6711, 6965, 6966, 6967, 6968, 7221, 7223, 7224, 7478, 7479, 15008, 15264, 15519, 15775, 6205, 6461, 6717, 8495, 8496, 8751, 8752, 9008, 9263, 9264, 9265});

    @Provides
    SmartMetronomeConfig provideConfig(ConfigManager configManager) {
        return (SmartMetronomeConfig)configManager.getConfig(SmartMetronomeConfig.class);
    }

    protected void startUp() {
        this.setMetronome();
        this.previousID = -1;
        this.previousPlane = -1;
        this.inventoryItems = false;
    }

    protected void shutDown() {
        this.tickCounter = 0;
        this.shouldTock = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            this.previousID = -1;
            this.previousPlane = -1;
        }
    }

    public void setABYSSAL_SIRE_REGIONS() {
        this.ABYSSAL_SIRE_REGIONS.put(11851, 0);
        this.ABYSSAL_SIRE_REGIONS.put(11850, 0);
        this.ABYSSAL_SIRE_REGIONS.put(12363, 0);
        this.ABYSSAL_SIRE_REGIONS.put(12362, 0);
    }

    public void setCERB_REGIONS() {
        this.CERB_REGIONS.put(4883, 0);
        this.CERB_REGIONS.put(5140, 0);
        this.CERB_REGIONS.put(5395, 0);
    }

    public void setCOMMANDER_ZILYANA_REGIONS() {
        this.COMMANDER_ZILYANA_REGIONS.put(11602, 0);
    }

    public void setCORP_BEAST_REGIONS() {
        this.CORP_BEAST_REGIONS.put(11842, 2);
        this.CORP_BEAST_REGIONS.put(11844, 2);
    }

    public void setDKS_REGIONS() {
        this.DKS_REGIONS.put(11588, 0);
        this.DKS_REGIONS.put(11589, 0);
    }

    public void setGENERAL_GRAARDOR_REGIONS() {
        this.GENERAL_GRAARDOR_REGIONS.put(11347, 2);
    }

    public void setGIANT_MOLE_REGIONS() {
        this.GIANT_MOLE_REGIONS.put(6993, 0);
        this.GIANT_MOLE_REGIONS.put(6992, 0);
    }

    public void setKRIL_REGIONS() {
        this.KRIL_REGIONS.put(11603, 2);
    }

    public void setKALPHITE_QUEEN_REGIONS() {
        this.KALPHITE_QUEEN_REGIONS.put(13972, 0);
    }

    public void setKREE_REGIONS() {
        this.KREE_REGIONS.put(11346, 2);
    }

    public void setSARACHNIS_REGIONS() {
        this.SARACHNIS_REGIONS.put(7322, 0);
    }

    public void setTHERMY_REGIONS() {
        this.THERMY_REGIONS.put(9363, 0);
        this.THERMY_REGIONS.put(9619, 0);
    }

    public void setWINTERTODT_REGIONS() {
        this.WINTERTODT_REGIONS.put(6462, 0);
    }

    public void setZALCANO_REGIONS() {
        this.ZALCANO_REGIONS.put(12126, 0);
    }

    public void setBLAST_FURNACE_REGIONS() {
        this.BLAST_FURNACE_REGIONS.put(7757, 0);
    }

    public void setBRIMHAVEN_AGILITY_REGIONS() {
        this.BRIMHAVEN_AGILITY_REGIONS.put(11157, 3);
    }

    public void setPYRAMID_PLUNDER_REGIONS() {
        this.PYRAMID_PLUNDER_REGIONS.put(7749, 0);
    }

    public void setCATACOMBS_REGIONS() {
        this.CATACOMBS_REGIONS.put(6556, 0);
        this.CATACOMBS_REGIONS.put(6557, 0);
        this.CATACOMBS_REGIONS.put(6812, 0);
        this.CATACOMBS_REGIONS.put(6813, 0);
    }

    public void setSTRONGHOLD_CAVE_REGIONS() {
        this.STRONGHOLD_CAVE_REGIONS.put(9624, 0);
        this.STRONGHOLD_CAVE_REGIONS.put(9625, 0);
        this.STRONGHOLD_CAVE_REGIONS.put(9880, 0);
        this.STRONGHOLD_CAVE_REGIONS.put(9881, 0);
    }

    public void setFREMENNIK_SLAYER_REGIONS() {
        this.FREMENNIK_SLAYER_REGIONS.put(11907, 0);
        this.FREMENNIK_SLAYER_REGIONS.put(10908, 0);
        this.FREMENNIK_SLAYER_REGIONS.put(11164, 0);
    }

    public void setMetronome() {
        this.setABYSSAL_SIRE_REGIONS();
        this.setCERB_REGIONS();
        this.setCOMMANDER_ZILYANA_REGIONS();
        this.setCORP_BEAST_REGIONS();
        this.setDKS_REGIONS();
        this.setGENERAL_GRAARDOR_REGIONS();
        this.setGIANT_MOLE_REGIONS();
        this.setKRIL_REGIONS();
        this.setKALPHITE_QUEEN_REGIONS();
        this.setKREE_REGIONS();
        this.setSARACHNIS_REGIONS();
        this.setTHERMY_REGIONS();
        this.setWINTERTODT_REGIONS();
        this.setZALCANO_REGIONS();
        this.setBLAST_FURNACE_REGIONS();
        this.setBRIMHAVEN_AGILITY_REGIONS();
        this.setPYRAMID_PLUNDER_REGIONS();
        this.setCATACOMBS_REGIONS();
        this.setFREMENNIK_SLAYER_REGIONS();
        this.setSTRONGHOLD_CAVE_REGIONS();
    }

    private boolean muteMetronomeIDs() {
        return MUTE_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID());
    }

    private boolean shouldActivateMetronome() {
        if (this.config.abyssalSireMetronome() && this.ABYSSAL_SIRE_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.ABYSSAL_SIRE_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.cerberusMetronome() && this.CERB_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.CERB_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.commanderZilyanaMetronome() && this.COMMANDER_ZILYANA_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.COMMANDER_ZILYANA_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.corpBeastMetronome() && this.CORP_BEAST_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.CORP_BEAST_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.dksMetronome() && this.DKS_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.DKS_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.generalGraardorMetronome() && this.GENERAL_GRAARDOR_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.GENERAL_GRAARDOR_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.giantMoleMetronome() && this.GIANT_MOLE_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.GIANT_MOLE_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.krilMetronome() && this.KRIL_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.KRIL_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.kqMetronome() && this.KALPHITE_QUEEN_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.KALPHITE_QUEEN_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.kreeMetronome() && this.KREE_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.KREE_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.sarachnisMetronome() && this.SARACHNIS_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.SARACHNIS_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.thermyMetronome() && this.THERMY_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.THERMY_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.wintertodtMetronome() && this.WINTERTODT_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.WINTERTODT_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.zalcanoMetronome() && this.ZALCANO_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.ZALCANO_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.blastFurnaceMetronome() && this.BLAST_FURNACE_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.BLAST_FURNACE_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.brimhavenAgilityMetronome() && this.BRIMHAVEN_AGILITY_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.BRIMHAVEN_AGILITY_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.pyramidPlunderMetronome() && this.PYRAMID_PLUNDER_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.PYRAMID_PLUNDER_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.catacombsMetronome() && this.CATACOMBS_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.CATACOMBS_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : (this.config.fremennikSlayerMetronome() && this.FREMENNIK_SLAYER_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) ? this.FREMENNIK_SLAYER_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane() : this.config.strongholdCaveMetronome() && this.STRONGHOLD_CAVE_REGIONS.containsKey(this.client.getLocalPlayer().getWorldLocation().getRegionID()) && this.STRONGHOLD_CAVE_REGIONS.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()).intValue() == this.client.getLocalPlayer().getWorldLocation().getPlane()))))))))))))))))))) {
            return true;
        }
        this.muteMetronomeIDs();
        return false;
    }

    private boolean isInInstance() {
        for (int mapregion : this.client.getMapRegions()) {
            if (this.muteMetronomeIDs()) {
                return false;
            }
            if (this.config.alchemicalHydraMetronome() && ALCHEMICAL_HYDRA_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.barrowsMetronome() && BARROWS_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.grotesqueGuardiansMetronome() && GROTESQUE_GUARDIANS_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.nightmareMetronome() && NIGHTMARE_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.skotizoMetronome() && SKOTIZO_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.vorkathMetronome() && VORKATH_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.zulrahMetronome() && ZULRAH_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.fightCaveMetronome() && FIGHT_CAVE_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.gauntletMetronome() && GAUNTLET_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.hallowedSepulchreMetronome() && HALLOWED_SEPULCHRE_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.infernoMetronome() && INFERNO_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.pestControlMetronome() && PEST_CONTROL_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.titheFarmMetronome() && TITHE_FARM_REGIONS.contains(mapregion)) {
                return true;
            }
            if (this.config.volcanicMineMetronome() && VOLCANIC_MINE_REGIONS.contains(mapregion)) {
                return true;
            }
            if (!this.config.slayerTowerMetronome() || !SLAYER_TOWER_REGIONS.contains(mapregion)) continue;
            return true;
        }
        return false;
    }

    private boolean varbits() {
        boolean inCoX = this.client.getVar(5425) > 0 && this.client.getVar(5425) < 5;
        boolean inBA = this.client.getVar(3923) == 1;
        boolean inPvP = this.client.getVar(8121) == 1;
        boolean inToB = this.client.getVar(6440) == 2;
        return this.config.chambersMetronome() && inCoX || this.config.theatreMetronome() && inToB || this.config.pvpMetronome() && inPvP || this.config.barbAssaultMetronome() && inBA;
    }

    public void tickTock() {
        if (++this.tickCounter % this.config.tickCount() == 0) {
            Preferences preferences = this.client.getPreferences();
            int previousVolume = preferences.getSoundEffectVolume();
            if (this.shouldTock && this.config.tockVolume() > 0) {
                preferences.setSoundEffectVolume(this.config.tockVolume());
                this.client.playSoundEffect(3930, this.config.tockVolume());
            } else if (this.config.tickVolume() > 0) {
                preferences.setSoundEffectVolume(this.config.tickVolume());
                this.client.playSoundEffect(3929, this.config.tickVolume());
            }
            preferences.setSoundEffectVolume(previousVolume);
            this.shouldTock = !this.shouldTock;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        ItemContainer itemContainer = event.getItemContainer();
        this.checkInventoryItems(itemContainer);
    }

    public void checkInventoryItems(ItemContainer itemContainer) {
        this.inventoryItems = false;
        for (int Herb : this.herbSet) {
            if (!itemContainer.contains(Herb) || !itemContainer.contains(1939) || !itemContainer.contains(233)) continue;
            this.inventoryItems = true;
            break;
        }
        for (int Vamb : this.vambSet) {
            if (!itemContainer.contains(Vamb) || !itemContainer.contains(10113)) continue;
            this.inventoryItems = true;
            break;
        }
        if (itemContainer.contains(946) && itemContainer.contains(6333)) {
            this.inventoryItems = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.config.tickCount() == 0) {
            return;
        }
        if (this.client.getLocalPlayer().getWorldLocation().getRegionID() != this.previousID || this.client.getLocalPlayer().getWorldLocation().getPlane() != this.previousPlane) {
            this.previousID = this.client.getLocalPlayer().getWorldLocation().getRegionID();
            this.previousPlane = this.client.getLocalPlayer().getWorldLocation().getPlane();
            boolean bl = this.shouldTickTock = this.shouldActivateMetronome() || this.isInInstance();
        }
        if (this.config.overrideMetronome() || this.shouldTickTock || this.config.tickManipMetronome() && this.inventoryItems || this.varbits()) {
            this.tickTock();
        }
    }
}

