/*
 * Decompiled with CFR 0.152.
 */
package com.aeimo.afkmovealert;

import com.aeimo.afkmovealert.AfkAlertConfig;
import com.aeimo.afkmovealert.AfkAlertOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="AFK Alerter (Movement only)", description="Gives a visual indicator when your character stops moving", tags={"afk", "runecrafting", "rc", "agil", "agility", "alert", "alerter"}, enabledByDefault=false)
public class AfkAlertPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AfkAlertPlugin.class);
    @Inject
    private AfkAlertConfig config;
    @Inject
    private AfkAlertOverlay overlay;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    private CachedSlidingWindow<LocalPoint> squaresLastStoodOn;

    @Provides
    AfkAlertConfig getConfig(ConfigManager configManager) {
        return (AfkAlertConfig)configManager.getConfig(AfkAlertConfig.class);
    }

    protected void startUp() throws Exception {
        this.resetLocationHistory();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    public boolean playerIsAfk() {
        if (this.isBankInterfaceOpen()) {
            return this.squaresLastStoodOn.allEqual(this.afkDurationBankTicks());
        }
        return this.squaresLastStoodOn.allEqual(this.afkDurationTicks());
    }

    public int getGlowBreathePeriod() {
        return this.config.glowSpeedMs();
    }

    public int getMaxBreatheIntensityPercent() {
        return this.config.maxBreatheIntensityPercent();
    }

    public Color getGlowColor() {
        return this.config.glowColor();
    }

    public int afkDurationTicks() {
        return AfkAlertPlugin.secondsToTicksRoundNearest(this.config.afkDurationThreshold());
    }

    public int afkDurationBankTicks() {
        return AfkAlertPlugin.secondsToTicksRoundNearest(this.config.afkDurationThresholdBank());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.resetLocationHistory();
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.squaresLastStoodOn.push(this.client.getLocalPlayer().getLocalLocation());
    }

    private void resetLocationHistory() {
        this.squaresLastStoodOn = new CachedSlidingWindow(Math.max(this.afkDurationTicks(), this.afkDurationBankTicks()));
    }

    private boolean isBankInterfaceOpen() {
        Widget widgetBankTitleBar = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
        Widget coxPublicChest = this.client.getWidget(550, 1);
        Widget coxPrivateChest = this.client.getWidget(271, 1);
        return widgetBankTitleBar != null && !widgetBankTitleBar.isHidden() || coxPublicChest != null && !coxPublicChest.isHidden() || coxPrivateChest != null && !coxPrivateChest.isHidden();
    }

    private static int secondsToTicksRoundNearest(int ticks) {
        return (int)Math.round((double)ticks / 0.6);
    }

    private static class CachedSlidingWindow<T> {
        private final Object[] slidingWindowItems;
        private Map<Integer, Boolean> allEqualCachedResult = null;

        public CachedSlidingWindow(int size) {
            this.slidingWindowItems = new Object[size];
        }

        void push(T obj) {
            this.allEqualCachedResult = null;
            if (this.slidingWindowItems.length - 1 >= 0) {
                System.arraycopy(this.slidingWindowItems, 1, this.slidingWindowItems, 0, this.slidingWindowItems.length - 1);
            }
            this.slidingWindowItems[this.slidingWindowItems.length - 1] = obj;
        }

        boolean allEqual(int n) {
            if (this.allEqualCachedResult == null) {
                this.allEqualCachedResult = new HashMap<Integer, Boolean>();
            }
            return this.allEqualCachedResult.computeIfAbsent(n, this::lastNEqual);
        }

        private Boolean lastNEqual(int n) {
            if (n > this.slidingWindowItems.length) {
                throw new RuntimeException(String.format("lastNEqual called with n=%d, slidingWindowItems.length=%d", n, this.slidingWindowItems.length));
            }
            int endIndex = this.slidingWindowItems.length - n;
            for (int i = this.slidingWindowItems.length - 1; i >= endIndex + 1; --i) {
                if (Objects.equals(this.slidingWindowItems[i], this.slidingWindowItems[i - 1])) continue;
                return false;
            }
            return true;
        }
    }
}

