/*
 * Decompiled with CFR 0.152.
 */
package com.aeimo.afkmovealert;

import com.aeimo.afkmovealert.AfkAlertPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;

public class AfkAlertOverlay
extends Overlay {
    private static final int MAX_BRIGHTNESS_ALPHA_LEVEL = 255;
    @Inject
    private AfkAlertPlugin plugin;
    @Inject
    private Client client;
    private boolean isRenderingAlertAnimation = false;

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.playerIsAfk()) {
            Color glowColor = this.plugin.getGlowColor();
            graphics.setColor(new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), this.getBreathingAlpha(this.plugin.getGlowBreathePeriod())));
            graphics.fill(this.getGameWindowRectangle());
        } else {
            this.isRenderingAlertAnimation = false;
        }
        return null;
    }

    private Rectangle getGameWindowRectangle() {
        Dimension clientCanvasSize = this.client.getCanvas().getSize();
        Point clientCanvasLocation = this.client.getCanvas().getLocation();
        Point adjustedLocation = new Point(clientCanvasLocation.x - 5, clientCanvasLocation.y - 20);
        return new Rectangle(adjustedLocation, clientCanvasSize);
    }

    private int getBreathingAlpha(int breathePeriodMillis) {
        double currentMillisOffset = System.currentTimeMillis() % (long)breathePeriodMillis;
        double fractionCycleComplete = currentMillisOffset / (double)breathePeriodMillis;
        int maxIntensityPc = this.plugin.getMaxBreatheIntensityPercent();
        double fractionAlpha = Math.sin(fractionCycleComplete * 2.0 * Math.PI);
        double fractionAlphaPositive = (fractionAlpha + 1.0) / 2.0;
        if (this.isRenderingAlertAnimation || fractionAlphaPositive < 0.025) {
            this.isRenderingAlertAnimation = true;
            return (int)(fractionAlphaPositive * 255.0 * ((double)maxIntensityPc / 100.0));
        }
        return 0;
    }
}

