/*
 * Decompiled with CFR 0.152.
 */
package com.aeimo.afkmovealert;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="afkalert")
public interface AfkAlertConfig
extends Config {
    public static final int DEFAULT_AFK_DURATION_S = 5;
    public static final int DEFAULT_GLOW_BREATHE_PERIOD_MS = 1000;
    public static final int DEFAULT_MAX_GLOW_BREATHE_INTENSITY = 100;
    public static final Color DEFAULT_GLOW_COLOR = new Color(255, 0, 0);

    @ConfigItem(name="AFK threshold", keyName="afkDurationThreshold", description="How long is the player idle before an AFK alert fires", position=0)
    @Units(value="s")
    default public int afkDurationThreshold() {
        return 5;
    }

    @ConfigItem(name="AFK threshold (Bank)", keyName="afkDurationThresholdBank", description="How long is the player idle with the bank open before an AFK alert fires", position=1)
    @Units(value="s")
    default public int afkDurationThresholdBank() {
        return 5;
    }

    @ConfigItem(name="Glow speed (ms)", keyName="glowSpeedMs", description="How long between cycles of min and max brightness of the glow effect", position=2)
    @Units(value="ms")
    default public int glowSpeedMs() {
        return 1000;
    }

    @ConfigItem(name="Max glow intensity", keyName="maxBreatheIntensityPercent", description="Max intensity of glow effect (100% is opaque)", position=3)
    @Units(value="%")
    @Range(min=10, max=100)
    default public int maxBreatheIntensityPercent() {
        return 100;
    }

    @Alpha
    @ConfigItem(position=4, keyName="glowColor", name="Glow color", description="The color of the glow effect")
    default public Color glowColor() {
        return DEFAULT_GLOW_COLOR;
    }
}

