/*
 * Decompiled with CFR 0.152.
 */
package com.snake;

import com.google.inject.Provides;
import com.snake.SnakeConfig;
import com.snake.SnakeOverlay;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.JagexColor;
import net.runelite.api.MenuAction;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.Player;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Snake")
public class SnakePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SnakePlugin.class);
    @Inject
    private Client client;
    @Inject
    private SnakeConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SnakeOverlay overlay;
    private State currentState;
    private WorldPoint playerWorldPosition;
    private WorldPoint previousPlayerWorldPosition;
    private LocalPoint playerLocalPosition;
    private Queue<RuneLiteObject> snakeTrail = new ArrayDeque<RuneLiteObject>();
    private int initialTrailSize = 2;
    private List<RuneLiteObject> walls = new ArrayList<RuneLiteObject>();
    private WorldPoint wallStartPoint;
    private int gameSize;
    private RuneLiteObject foodObject;
    private int wallModelId = 32693;
    private int foodModelId = 2317;
    private int trailModelId = 29311;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.currentState = State.INIT;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invokeLater(() -> {
            this.resetGame();
            return true;
        });
    }

    public Integer getScore() {
        return this.snakeTrail.size() - this.initialTrailSize;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.previousPlayerWorldPosition = this.playerWorldPosition;
        this.playerWorldPosition = this.client.getLocalPlayer().getWorldLocation();
        this.playerLocalPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.playerWorldPosition);
        switch (this.currentState) {
            case INIT: {
                this.initializeGame();
                break;
            }
            case WAITING_TO_START: {
                if (this.checkPlayerRunning()) {
                    this.currentState = State.RUN_ON;
                    break;
                }
                if (this.previousPlayerWorldPosition.equals((Object)this.playerWorldPosition)) break;
                this.gameLoop();
                this.currentState = State.PLAYING;
                break;
            }
            case PLAYING: {
                this.gameLoop();
                break;
            }
        }
    }

    private void initializeGame() {
        for (int i = 0; i < this.initialTrailSize; ++i) {
            this.snakeTrail.add(this.spawnNewSnakeTrailObject());
        }
        this.updateGameSize();
        this.drawWalls();
        this.createFoodObj();
        this.respawnFood();
        this.currentState = State.WAITING_TO_START;
    }

    private void gameLoop() {
        if (this.checkPlayerRunning()) {
            this.currentState = State.RUN_ON;
        } else if (this.checkInvalidMovement()) {
            Player localPlayer = this.client.getLocalPlayer();
            localPlayer.setAnimation(2925);
            localPlayer.setAnimationFrame(0);
            localPlayer.setOverheadCycle(150);
            localPlayer.setOverheadText("Game Over!");
            this.currentState = State.GAME_OVER;
        } else if (this.playerLocalPosition.equals((Object)this.foodObject.getLocation())) {
            this.snakeTrail.add(this.spawnNewSnakeTrailObject());
            this.foodObject.setActive(false);
            this.respawnFood();
        } else {
            RuneLiteObject snakeTrailObj = this.snakeTrail.poll();
            snakeTrailObj.setLocation(this.playerLocalPosition, this.client.getPlane());
            this.snakeTrail.add(snakeTrailObj);
        }
    }

    private void resetGame() {
        this.clearSnakeTrail();
        this.clearWalls();
        this.foodObject.setActive(false);
        this.currentState = State.INIT;
    }

    private boolean checkInvalidMovement() {
        boolean inGameBoundary;
        boolean bl = inGameBoundary = this.playerWorldPosition.getX() > this.wallStartPoint.getX() && this.playerWorldPosition.getX() <= this.wallStartPoint.getX() + this.gameSize && this.playerWorldPosition.getY() < this.wallStartPoint.getY() && this.playerWorldPosition.getY() >= this.wallStartPoint.getY() - this.gameSize;
        if (!inGameBoundary) {
            return true;
        }
        for (RuneLiteObject trailObj : this.snakeTrail) {
            if (!this.playerLocalPosition.equals((Object)trailObj.getLocation())) continue;
            return true;
        }
        return false;
    }

    private void clearSnakeTrail() {
        for (RuneLiteObject obj : this.snakeTrail) {
            obj.setActive(false);
        }
        this.snakeTrail.clear();
    }

    private RuneLiteObject spawnNewSnakeTrailObject() {
        RuneLiteObject obj = this.client.createRuneLiteObject();
        ModelData trailModel = this.client.loadModelData(this.trailModelId).cloneColors();
        trailModel.recolor(trailModel.getFaceColors()[0], JagexColor.rgbToHSL((int)new Color(32, 139, 25).getRGB(), (double)1.0));
        trailModel.recolor(trailModel.getFaceColors()[1], JagexColor.rgbToHSL((int)new Color(59, 148, 74).getRGB(), (double)1.0));
        obj.setModel(trailModel.light());
        obj.setLocation(this.playerLocalPosition, this.client.getPlane());
        obj.setActive(true);
        return obj;
    }

    private void createFoodObj() {
        this.foodObject = this.client.createRuneLiteObject();
        ModelData foodModel = ((ModelData)this.client.loadModelData(this.foodModelId).cloneVertices().translate(0, 200, 0)).cloneColors();
        foodModel.recolor(foodModel.getFaceColors()[0], JagexColor.rgbToHSL((int)new Color(186, 16, 225).getRGB(), (double)1.0));
        this.foodObject.setModel(foodModel.light());
        this.foodObject.setAnimation(this.client.loadAnimation(502));
        this.foodObject.setShouldLoop(true);
    }

    private void respawnFood() {
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.getRandomPointInGrid());
        this.foodObject.setLocation(lp, this.client.getPlane());
        this.foodObject.setActive(true);
    }

    private void clearWalls() {
        for (RuneLiteObject obj : this.walls) {
            obj.setActive(false);
        }
        this.walls.clear();
    }

    private void drawWalls() {
        int y;
        int x;
        this.clearWalls();
        int offset = (int)Math.ceil((float)this.gameSize / 2.0f);
        this.wallStartPoint = this.playerWorldPosition.dx(-offset).dy(offset);
        for (x = 0; x < this.gameSize + 2; ++x) {
            this.walls.add(this.spawnWallObject(this.wallStartPoint.dx(x)));
        }
        for (x = 0; x < this.gameSize + 2; ++x) {
            this.walls.add(this.spawnWallObject(this.wallStartPoint.dx(x).dy(-offset * 2)));
        }
        for (y = 0; y < this.gameSize; ++y) {
            this.walls.add(this.spawnWallObject(this.wallStartPoint.dy(-y - 1)));
        }
        for (y = 0; y < this.gameSize; ++y) {
            this.walls.add(this.spawnWallObject(this.wallStartPoint.dy(-y - 1).dx(offset * 2)));
        }
    }

    private RuneLiteObject spawnWallObject(WorldPoint point) {
        RuneLiteObject obj = this.client.createRuneLiteObject();
        Model wall = this.client.loadModel(this.wallModelId);
        obj.setModel(wall);
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        obj.setLocation(lp, this.client.getPlane());
        obj.setActive(true);
        return obj;
    }

    private WorldPoint getRandomPointInGrid() {
        int y;
        int x;
        WorldPoint randomPoint;
        do {
            x = ThreadLocalRandom.current().nextInt(0, this.gameSize);
            y = ThreadLocalRandom.current().nextInt(0, this.gameSize);
        } while ((randomPoint = this.wallStartPoint.dx(x + 1).dy(-(y + 1))).equals((Object)this.playerWorldPosition));
        return randomPoint;
    }

    private boolean checkPlayerRunning() {
        return this.previousPlayerWorldPosition != null && this.playerLocalPosition != null && this.previousPlayerWorldPosition.distanceTo(this.playerWorldPosition) > 1;
    }

    private void updateGameSize() {
        this.gameSize = 1 + 2 * this.config.gameSize();
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked overlayMenuClicked) {
        OverlayMenuEntry overlayMenuEntry = overlayMenuClicked.getEntry();
        if (overlayMenuEntry.getMenuAction() == MenuAction.RUNELITE_OVERLAY && overlayMenuClicked.getEntry().getOption().equals("Start") && overlayMenuClicked.getOverlay() == this.overlay) {
            this.resetGame();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("snakeConfig")) {
            this.updateGameSize();
            this.clientThread.invokeLater(() -> {
                this.resetGame();
                return true;
            });
        }
    }

    @Provides
    SnakeConfig provideConfig(ConfigManager configManager) {
        return (SnakeConfig)configManager.getConfig(SnakeConfig.class);
    }

    public State getCurrentState() {
        return this.currentState;
    }

    static enum State {
        INIT,
        WAITING_TO_START,
        PLAYING,
        GAME_OVER,
        RUN_ON;

    }
}

