/*
 * Decompiled with CFR 0.152.
 */
package com.snake;

import com.snake.SnakeConfig;
import com.snake.SnakePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class SnakeOverlay
extends OverlayPanel {
    private Client client;
    private SnakePlugin plugin;
    private SnakeConfig config;
    @Inject
    SpriteManager spriteManager;
    private boolean hitsplatTimerStarted;
    private long hitsplatStart;

    @Inject
    SnakeOverlay(SnakePlugin plugin, Client client, SnakeConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Start", "new game"));
    }

    public Dimension render(Graphics2D graphics) {
        Color color;
        String title;
        switch (this.plugin.getCurrentState()) {
            case INIT: {
                this.hitsplatStart = 0L;
            }
            case PLAYING: {
                title = "Playing";
                color = Color.GREEN;
                break;
            }
            case GAME_OVER: {
                title = "Game Over";
                color = Color.RED;
                if (this.hitsplatStart == 0L) {
                    this.hitsplatStart = System.currentTimeMillis();
                    break;
                }
                long timerDiff = System.currentTimeMillis() - this.hitsplatStart;
                if (timerDiff > 1000L) break;
                this.renderHitsplat(graphics);
                break;
            }
            case WAITING_TO_START: {
                title = "Move to start";
                color = Color.YELLOW;
                break;
            }
            case RUN_ON: {
                title = "Running is not allowed";
                color = Color.RED;
                break;
            }
            default: {
                return super.render(graphics);
            }
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text(title).color(color).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Score:").right(String.format("%d", this.plugin.getScore())).build());
        return super.render(graphics);
    }

    private void renderHitsplat(Graphics2D graphics) {
        BufferedImage image = this.spriteManager.getSprite(1360, 0);
        Point playerLocation = Perspective.getCanvasImageLocation((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation(), (BufferedImage)image, (int)98);
        Point imageLocation = new Point(playerLocation.getX() - 5, playerLocation.getY() - 22);
        OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)imageLocation, (BufferedImage)image);
        Point textLocation = new Point(playerLocation.getX() - 3, playerLocation.getY() - 3);
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)"99", (Color)Color.WHITE);
    }
}

