/*
 * Decompiled with CFR 0.152.
 */
package discordcollectionlogger;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import discordcollectionlogger.DiscordCollectionLoggerConfig;
import discordcollectionlogger.WebhookBody;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.item.ItemPrice;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Collection Logger")
public class DiscordCollectionLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordCollectionLoggerPlugin.class);
    @Inject
    private DiscordCollectionLoggerConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private DrawManager drawManager;
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*");
    private static final String COLLECTION_LOG_TEXT = "New item added to your collection log: ";
    private static final Pattern Pet_LOG_ITEM_REGEX = Pattern.compile("You have a funny feeling like you.*");
    @Inject
    private Client client;
    private boolean delayScreenshot;

    private static String itemImageUrl(int itemId) {
        return "https://static.runelite.net/cache/item/icon/" + itemId + ".png";
    }

    protected void startUp() {
    }

    protected void shutDown() {
        this.delayScreenshot = false;
    }

    @Provides
    DiscordCollectionLoggerConfig provideConfig(ConfigManager configManager) {
        return (DiscordCollectionLoggerConfig)configManager.getConfig(DiscordCollectionLoggerConfig.class);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        String inputMessage = chatMessage.getMessage();
        Object outputMessage = Text.removeTags((String)inputMessage);
        if (this.config.includeCollectionLog() && COLLECTION_LOG_ITEM_REGEX.matcher((CharSequence)outputMessage).matches() && this.client.getVarbitValue(11959) == 1) {
            String item = ((String)outputMessage).substring(COLLECTION_LOG_TEXT.length());
            outputMessage = "New item added to your collection log: **" + item + "**";
            this.processCollection(item, (String)outputMessage);
        }
        if (this.config.includePets() && Pet_LOG_ITEM_REGEX.matcher((CharSequence)outputMessage).matches()) {
            this.processCollection((String)outputMessage);
        }
    }

    private String getPlayerName() {
        return this.client.getLocalPlayer().getName();
    }

    private void processCollection(String itemName, String outputText) {
        int itemId;
        WebhookBody webhookBody = new WebhookBody();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.config.includeUsername()) {
            stringBuilder.append("\n**").append(this.getPlayerName()).append("**").append("\n");
        }
        stringBuilder.append(outputText).append("\n");
        if (this.config.includeCollectionImage() && (itemId = this.getItemID(itemName)) >= 0) {
            webhookBody.getEmbeds().add(new WebhookBody.Embed(new WebhookBody.UrlEmbed(DiscordCollectionLoggerPlugin.itemImageUrl(itemId))));
        }
        webhookBody.setContent(stringBuilder.toString());
        this.sendWebhook(webhookBody);
    }

    private void processCollection(String outputText) {
        WebhookBody webhookBody = new WebhookBody();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.config.includeUsername()) {
            stringBuilder.append("\n**").append(this.getPlayerName()).append("**").append("\n");
        }
        stringBuilder.append(outputText).append("\n");
        webhookBody.setContent(stringBuilder.toString());
        this.sendWebhook(webhookBody);
    }

    private int getItemID(String itemName) {
        List items = this.itemManager.search(itemName);
        if (items.size() == 1) {
            return ((ItemPrice)items.get(0)).getId();
        }
        return -1;
    }

    private void sendWebhook(WebhookBody webhookBody) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        String[] configArray = configUrl.split(",");
        for (int i = 0; i < configArray.length; ++i) {
            HttpUrl url = HttpUrl.parse((String)configArray[i].trim());
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)webhookBody));
            if (this.config.sendScreenshot()) {
                this.sendWebhookWithScreenshot(url, requestBodyBuilder);
                continue;
            }
            this.buildRequestAndSend(url, requestBodyBuilder);
        }
    }

    private void sendWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = DiscordCollectionLoggerPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        switch (scriptPreFired.getScriptId()) {
            case 3346: {
                this.delayScreenshot = true;
                break;
            }
            case 3347: {
                if (!this.delayScreenshot) {
                    return;
                }
                String notificationTopText = this.client.getVarcStrValue(387);
                String notificationBottomText = this.client.getVarcStrValue(388);
                if (notificationTopText.equalsIgnoreCase("Collection log") && this.config.includeCollectionLog()) {
                    String item = Text.removeTags((String)notificationBottomText).substring("New item:".length());
                    String outputText = "New item added to your collection log: **" + item + "**";
                    this.processCollection(item, outputText);
                }
                this.delayScreenshot = false;
            }
        }
    }
}

