/*
 * Decompiled with CFR 0.152.
 */
package com.f2pwiki;

import com.f2pwiki.f2pwikiConfig;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="F2P Wiki", description="Automatically updates your stats on external xptrackers when you log out", tags={"f2pwiki", "f2p wiki", "f2p.wiki", "external", "integration"})
public class f2pwikiPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(f2pwikiPlugin.class);
    private static final int XP_THRESHOLD = 10000;
    @Inject
    private Client client;
    @Inject
    private f2pwikiConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    private String lastUsername;
    private boolean fetchXp;
    private long lastXp;

    @Provides
    f2pwikiConfig getConfig(ConfigManager configManager) {
        return (f2pwikiConfig)configManager.getConfig(f2pwikiConfig.class);
    }

    protected void startUp() {
        this.fetchXp = true;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state == GameState.LOGGED_IN) {
            if (!Objects.equals(this.client.getUsername(), this.lastUsername)) {
                this.lastUsername = this.client.getUsername();
                this.fetchXp = true;
            }
        } else if (state == GameState.LOGIN_SCREEN) {
            Player local = this.client.getLocalPlayer();
            if (local == null) {
                return;
            }
            long totalXp = this.client.getOverallExperience();
            if (Math.abs(totalXp - this.lastXp) > 10000L) {
                log.debug("Submitting update for {}", (Object)local.getName());
                this.update(local.getName());
                this.lastXp = totalXp;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.fetchXp) {
            this.lastXp = this.client.getOverallExperience();
            this.fetchXp = false;
        }
    }

    private void update(String username) {
        EnumSet worldTypes = this.client.getWorldType();
        username = username.replace(" ", "_");
        this.updateF2PWiki(username, worldTypes);
    }

    private void updateF2PWiki(String username, EnumSet<WorldType> worldTypes) {
        if (this.config.f2pwiki()) {
            HttpUrl url = new HttpUrl.Builder().scheme("https").host("www.f2p.wiki").addPathSegment("players").addPathSegment(username).addPathSegment("update").build();
            Request request = new Request.Builder().header("User-Agent", "RuneLite").url(url).build();
            this.sendRequest("F2PWiki", request);
        }
    }

    private void sendRequest(final String platform, Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error submitting {} update, caused by {}.", (Object)platform, (Object)e.getMessage());
            }

            public void onResponse(Call call, Response response) {
                response.close();
            }
        });
    }
}

