/*
 * Decompiled with CFR 0.152.
 */
package com.partydefencetracker;

import com.google.inject.Provides;
import com.partydefencetracker.BossInfo;
import com.partydefencetracker.CoXLayoutSolver;
import com.partydefencetracker.DefenceInfoBox;
import com.partydefencetracker.DefenceTrackerConfig;
import com.partydefencetracker.DefenceTrackerUpdate;
import com.partydefencetracker.QueuedNpc;
import com.partydefencetracker.RedKerisInfoBox;
import com.partydefencetracker.VulnerabilityInfoBox;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.IndexDataBase;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.SpritePixels;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.party.PartyPlugin;
import net.runelite.client.plugins.specialcounter.SpecialCounterUpdate;
import net.runelite.client.plugins.specialcounter.SpecialWeapon;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Party Defence Tracker", description="Calculates the defence based off party specs", tags={"party", "defence", "tracker", "boosting", "special", "counter"})
@PluginDependency(value=PartyPlugin.class)
public class DefenceTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DefenceTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PartyService partyService;
    @Inject
    private WSClient wsClient;
    @Inject
    private DefenceTrackerConfig config;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private CoXLayoutSolver layoutSolver;
    private String boss = "";
    private int bossIndex = 0;
    private double bossDef = -1.0;
    private DefenceInfoBox box = null;
    private VulnerabilityInfoBox vulnBox = null;
    private SpritePixels vuln = null;
    private RedKerisInfoBox redKerisBox = null;
    private int redKerisTicks = 0;
    private int hitsplatTick;
    private Hitsplat lastSpecHitsplat;
    private NPC lastSpecTarget;
    private double lastSpecPercent = -1.0;
    private boolean hmXarpus = false;
    private boolean bloatDown = false;
    private boolean inCm;
    private boolean coxModeSet = false;
    private QueuedNpc queuedNpc = null;
    Map<String, ArrayList<Integer>> bossRegions = new HashMap<String, ArrayList<Integer>>(){
        {
            this.put("The Maiden of Sugadinti", new ArrayList<Integer>(Collections.singletonList(12613)));
            this.put("Pestilent Bloat", new ArrayList<Integer>(Collections.singletonList(13125)));
            this.put("Nylocas Vasilias", new ArrayList<Integer>(Collections.singletonList(13122)));
            this.put("Sotetseg", new ArrayList<Integer>(Arrays.asList(13123, 13379)));
            this.put("Xarpus", new ArrayList<Integer>(Collections.singletonList(12612)));
            this.put("Zebak", new ArrayList<Integer>(Collections.singletonList(15700)));
            this.put("Kephri", new ArrayList<Integer>(Collections.singletonList(14164)));
            this.put("Ba-Ba", new ArrayList<Integer>(Collections.singletonList(15188)));
            this.put("Akkha", new ArrayList<Integer>(Collections.singletonList(14676)));
            this.put("Akkha's Shadow", new ArrayList<Integer>(Collections.singletonList(14676)));
            this.put("<col=00ffff>Obelisk</col>", new ArrayList<Integer>(Collections.singletonList(15184)));
            this.put("Tumeken's Warden", new ArrayList<Integer>(Collections.singletonList(15696)));
            this.put("Elidinis' Warden", new ArrayList<Integer>(Collections.singletonList(15696)));
            this.put("<col=00ffff>Core</col>", new ArrayList<Integer>(Arrays.asList(15184, 15696)));
            this.put("Alchemical Hydra", new ArrayList<Integer>(Collections.singletonList(5536)));
            this.put("Nex", new ArrayList<Integer>(Collections.singletonList(11601)));
            this.put("Phantom Muspah", new ArrayList<Integer>(Collections.singletonList(11330)));
            this.put("Skotizo", new ArrayList<Integer>(Collections.singletonList(9048)));
            this.put("TzKal-Zuk", new ArrayList<Integer>(Collections.singletonList(9043)));
            this.put("TzTok-Jad", new ArrayList<Integer>(Collections.singletonList(9551)));
            this.put("Vorkath", new ArrayList<Integer>(Collections.singletonList(9023)));
            this.put("Zulrah", new ArrayList<Integer>(Arrays.asList(9007, 9008)));
        }
    };
    private final List<String> coxBosses = Arrays.asList("Great Olm (Left claw)", "Ice demon", "Skeletal Mystic", "Tekton", "Vasa Nistirio");

    @Provides
    DefenceTrackerConfig provideConfig(ConfigManager configManager) {
        return (DefenceTrackerConfig)configManager.getConfig(DefenceTrackerConfig.class);
    }

    protected void startUp() throws Exception {
        this.reset();
        this.enableRequiredPlugins("Party");
        this.enableRequiredPlugins("Special Attack Counter");
        this.wsClient.registerMessage(DefenceTrackerUpdate.class);
    }

    protected void shutDown() throws Exception {
        this.reset();
        this.wsClient.unregisterMessage(DefenceTrackerUpdate.class);
    }

    protected void reset() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.box);
        this.infoBoxManager.removeInfoBox((InfoBox)this.vulnBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.redKerisBox);
        this.boss = "";
        this.bossIndex = 0;
        this.bossDef = -1.0;
        this.box = null;
        this.vulnBox = null;
        this.vuln = null;
        this.redKerisBox = null;
        this.redKerisTicks = 0;
        this.bloatDown = false;
        this.queuedNpc = null;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        int animation = e.getActor().getAnimation();
        if (e.getActor() instanceof Player && e.getActor() != null && this.client.getLocalPlayer() != null && e.getActor().getName() != null && e.getActor().getName().equals(this.client.getLocalPlayer().getName()) && animation == 1816 && this.boss.equalsIgnoreCase("sotetseg") && this.inBossRegion()) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.box);
            this.bossDef = 200.0;
        }
        if (e.getActor() instanceof NPC && e.getActor().getName() != null) {
            if (e.getActor().getName().equalsIgnoreCase("pestilent bloat")) {
                this.bloatDown = animation == 8082;
            } else if (animation == 9685 && (this.boss.equalsIgnoreCase("Tumeken's Warden") || this.boss.equalsIgnoreCase("Elidinis' Warden"))) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.box);
                this.bossDef = 60.0;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        if (this.partyService.isInParty()) {
            for (NPC n : this.client.getNpcs()) {
                if (n == null || n.getName() == null || !n.getName().equalsIgnoreCase(this.boss) && (!n.getName().contains("Tekton") || !this.boss.equalsIgnoreCase("Tekton")) || !n.isDead() && n.getHealthRatio() != 0) continue;
                this.partyService.send((PartyMessage)new DefenceTrackerUpdate(n.getName(), n.getIndex(), false, this.client.getWorld(), ""));
            }
        }
        this.layoutSolver.onGameTick(e);
        if (!this.coxModeSet && this.client.getVarbitValue(5432) == 1) {
            this.inCm = this.layoutSolver.isCM();
            this.coxModeSet = true;
        }
        if (this.redKerisTicks > 0) {
            --this.redKerisTicks;
            if (this.redKerisTicks == 0) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.redKerisBox);
            }
        }
        if (this.lastSpecHitsplat != null && this.lastSpecTarget != null) {
            if (this.lastSpecHitsplat.getAmount() > 0 && this.partyService.isInParty()) {
                this.partyService.send((PartyMessage)new DefenceTrackerUpdate(this.lastSpecTarget.getName(), this.lastSpecTarget.getIndex(), true, this.client.getWorld(), "keris"));
            }
            this.lastSpecHitsplat = null;
            this.lastSpecTarget = null;
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied e) {
        NPC npc;
        String name;
        Actor target = e.getActor();
        Hitsplat hitsplat = e.getHitsplat();
        if (hitsplat.isMine() && target instanceof NPC && this.lastSpecTarget != null && this.hitsplatTick == this.client.getTickCount() && (name = (npc = (NPC)target).getName()) != null && (BossInfo.getBoss(name) != null || this.bossIndex == npc.getIndex())) {
            this.lastSpecHitsplat = hitsplat;
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned e) {
        NPC npc = e.getNpc();
        if (npc.getName() != null && BossInfo.getBoss(npc.getName()) != null) {
            this.hmXarpus = npc.getId() >= 10770 && npc.getId() <= 10772;
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath e) {
        if (e.getActor() instanceof NPC && e.getActor().getName() != null && this.client.getLocalPlayer() != null && this.partyService.isInParty() && (e.getActor().getName().equalsIgnoreCase(this.boss) || e.getActor().getName().contains("Tekton") && this.boss.equalsIgnoreCase("Tekton"))) {
            this.partyService.send((PartyMessage)new DefenceTrackerUpdate(e.getActor().getName(), ((NPC)e.getActor()).getIndex(), false, this.client.getWorld(), ""));
        }
    }

    @Subscribe
    public void onSpecialCounterUpdate(SpecialCounterUpdate e) {
        int hit = e.getHit();
        int world = e.getWorld();
        SpecialWeapon weapon = e.getWeapon();
        int index = e.getNpcIndex();
        NPC npc = this.client.getCachedNPCs()[index];
        this.clientThread.invoke(() -> {
            if (npc != null && npc.getName() != null && BossInfo.getBoss(npc.getName()) != null || this.bossIndex == index) {
                String bossName;
                if (this.bossIndex != index && (!this.boss.equalsIgnoreCase(bossName = npc.getName()) || bossName.contains("Tekton") && !this.boss.equalsIgnoreCase("Tekton"))) {
                    this.baseDefence(bossName, index);
                    this.calculateQueue(index);
                }
                if (this.inBossRegion() && world == this.client.getWorld()) {
                    this.calculateDefence(weapon, hit);
                    this.updateDefInfobox();
                }
            } else {
                if (this.queuedNpc == null || this.queuedNpc.index != index) {
                    this.queuedNpc = new QueuedNpc(index);
                }
                this.queuedNpc.queuedSpecs.add(new QueuedNpc.QueuedSpec(weapon, hit));
            }
        });
    }

    @Subscribe
    public void onDefenceTrackerUpdate(DefenceTrackerUpdate e) {
        int world = e.getWorld();
        this.clientThread.invoke(() -> {
            if (!e.isAlive()) {
                this.reset();
            } else if (this.inBossRegion() && world == this.client.getWorld()) {
                if (e.getWeapon().equals("vuln")) {
                    if (!this.boss.equalsIgnoreCase(e.getBoss()) || e.getBoss().contains("Tekton") && !this.boss.equalsIgnoreCase("Tekton")) {
                        this.baseDefence(e.getBoss(), e.getIndex());
                        this.calculateQueue(e.getIndex());
                    }
                    if (this.config.vulnerability()) {
                        this.infoBoxManager.removeInfoBox((InfoBox)this.vulnBox);
                        IndexDataBase sprite = this.client.getIndexSprites();
                        this.vuln = Objects.requireNonNull(this.client.getSprites(sprite, 56, 0))[0];
                        this.vulnBox = new VulnerabilityInfoBox(this.vuln.toBufferedImage(), this);
                        this.vulnBox.setTooltip(ColorUtil.wrapWithColorTag((String)Text.removeTags((String)this.boss), (Color)Color.WHITE));
                        this.infoBoxManager.addInfoBox((InfoBox)this.vulnBox);
                    }
                    this.bossDef -= this.bossDef * 0.1;
                    this.updateDefInfobox();
                } else if (e.getWeapon().equals("keris")) {
                    this.redKerisTicks = 9;
                    if (this.config.redKeris()) {
                        this.infoBoxManager.removeInfoBox((InfoBox)this.redKerisBox);
                        this.redKerisBox = new RedKerisInfoBox((BufferedImage)this.itemManager.getImage(27287), this);
                        this.redKerisBox.setTooltip(ColorUtil.wrapWithColorTag((String)e.getBoss(), (Color)Color.WHITE));
                        this.infoBoxManager.addInfoBox((InfoBox)this.redKerisBox);
                    }
                }
            }
        });
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION && Text.removeTags((String)event.getMessage()).equals("The raid has begun!") && this.client.getVarbitValue(5432) == 1) {
            this.inCm = this.layoutSolver.isCM();
            this.coxModeSet = true;
        }
    }

    @Subscribe
    private void onVarbitChanged(VarbitChanged e) {
        if (!this.inBossRegion()) {
            this.reset();
        }
        if (this.client.getVarbitValue(5432) != 1 && this.isInCoxLobby()) {
            this.inCm = false;
            this.coxModeSet = false;
        }
        this.layoutSolver.onVarbitChanged(e);
        if (e.getVarpId() == 300) {
            int weapon;
            if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getPlayerComposition() != null && (weapon = this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(KitType.WEAPON)) == 27287 && ((double)e.getValue() == this.lastSpecPercent - 750.0 || (double)e.getValue() == this.lastSpecPercent - 375.0)) {
                int serverTicks = this.client.getTickCount();
                this.clientThread.invokeLater(() -> {
                    Actor target = this.client.getLocalPlayer().getInteracting();
                    this.lastSpecTarget = target instanceof NPC ? (NPC)target : null;
                    this.hitsplatTick = serverTicks + 1;
                });
            }
            this.lastSpecPercent = e.getValue();
        }
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged e) {
        if (e.getActor() instanceof NPC && e.getActor().getName() != null && e.getActor().hasSpotAnim(169) && this.partyService.isInParty() && BossInfo.getBoss(e.getActor().getName()) != null) {
            this.partyService.send((PartyMessage)new DefenceTrackerUpdate(e.getActor().getName(), ((NPC)e.getActor()).getIndex(), true, this.client.getWorld(), "vuln"));
        }
    }

    @Subscribe
    protected void onGameStateChanged(GameStateChanged e) {
        this.layoutSolver.onGameStateChanged(e);
    }

    private void baseDefence(String bossName, int index) {
        this.boss = bossName;
        this.bossIndex = index;
        this.bossDef = BossInfo.getBaseDefence(this.boss);
        if (this.boss.equalsIgnoreCase("Xarpus") && this.hmXarpus) {
            this.bossDef = 200.0;
        } else if (this.coxBosses.contains(this.boss)) {
            this.bossDef *= 1.0 + 0.01 * (double)(this.client.getVarbitValue(5424) - 1);
            if (this.inCm) {
                this.bossDef *= this.boss.contains("Tekton") ? 1.2 : 1.5;
            }
        }
    }

    private void calculateDefence(SpecialWeapon weapon, int hit) {
        switch (weapon) {
            case DRAGON_WARHAMMER: {
                if (hit == 0) {
                    if (this.client.getVarbitValue(5432) != 1 || !this.boss.equalsIgnoreCase("Tekton")) break;
                    this.bossDef -= this.bossDef * 0.05;
                    break;
                }
                this.bossDef -= this.bossDef * 0.3;
                break;
            }
            case BANDOS_GODSWORD: {
                if (hit == 0) {
                    if (this.client.getVarbitValue(5432) != 1 || !this.boss.equalsIgnoreCase("Tekton")) break;
                    this.bossDef -= 10.0;
                    break;
                }
                if (this.boss.equalsIgnoreCase("Corporeal Beast") || this.inBossRegion() && this.boss.equalsIgnoreCase("Pestilent Bloat") && !this.bloatDown) {
                    this.bossDef -= (double)(hit * 2);
                    break;
                }
                this.bossDef -= (double)hit;
                break;
            }
            case ARCLIGHT: 
            case DARKLIGHT: {
                if (hit <= 0) break;
                if (this.boss.equalsIgnoreCase("K'ril Tsutsaroth") || this.boss.equalsIgnoreCase("Abyssal Sire")) {
                    this.bossDef -= BossInfo.getBaseDefence(this.boss) * 0.1;
                    break;
                }
                this.bossDef -= BossInfo.getBaseDefence(this.boss) * 0.05;
                break;
            }
            case BARRELCHEST_ANCHOR: {
                this.bossDef -= (double)hit * 0.1;
                break;
            }
            case BONE_DAGGER: 
            case DORGESHUUN_CROSSBOW: {
                this.bossDef -= (double)hit;
                break;
            }
            case ACCURSED_SCEPTRE: {
                if (hit <= 0 || !(this.bossDef > BossInfo.getBaseDefence(this.boss) * 0.85)) break;
                this.bossDef = BossInfo.getBaseDefence(this.boss) * 0.85;
            }
        }
        if (this.boss.equalsIgnoreCase("Sotetseg") && this.bossDef < 100.0) {
            this.bossDef = 100.0;
        } else if (this.bossDef < 0.0) {
            this.bossDef = 0.0;
        }
    }

    private void calculateQueue(int index) {
        if (this.queuedNpc != null) {
            if (this.queuedNpc.index == index) {
                for (QueuedNpc.QueuedSpec spec : this.queuedNpc.queuedSpecs) {
                    this.calculateDefence(spec.weapon, spec.hit);
                }
            }
            this.queuedNpc = null;
        }
    }

    private void updateDefInfobox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.box);
        this.box = new DefenceInfoBox(this.skillIconManager.getSkillImage(Skill.DEFENCE), this, Math.round(this.bossDef), this.config);
        this.box.setTooltip(ColorUtil.wrapWithColorTag((String)this.boss, (Color)Color.WHITE));
        this.infoBoxManager.addInfoBox((InfoBox)this.box);
    }

    private boolean inBossRegion() {
        WorldPoint wp;
        if (this.client.getLocalPlayer() != null && this.bossRegions.containsKey(this.boss) && (wp = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation())) != null) {
            return this.bossRegions.get(this.boss).contains(wp.getRegionID());
        }
        return this.client.getVarbitValue(5432) == 1 || !this.coxBosses.contains(this.boss);
    }

    public boolean isInCoxLobby() {
        return this.client.getMapRegions() != null && this.client.getMapRegions().length > 0 && Arrays.stream(this.client.getMapRegions()).anyMatch(s -> s == 4919);
    }

    public void enableRequiredPlugins(String pluginName) {
        try {
            Optional<Plugin> plugin = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals(pluginName)).findFirst();
            if (plugin.isPresent() && !this.pluginManager.isPluginEnabled(plugin.get())) {
                this.pluginManager.setPluginEnabled(plugin.get(), true);
                this.pluginManager.startPlugin(plugin.get());
            }
        }
        catch (PluginInstantiationException ex) {
            log.error("error starting " + pluginName + " plugin", (Throwable)ex);
        }
    }

    public int getRedKerisTicks() {
        return this.redKerisTicks;
    }
}

