/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.bitwarden;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import io.ryoung.bitwarden.BitwardenConfig;
import io.ryoung.bitwarden.CommandRunner;
import io.ryoung.bitwarden.Credential;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;

final class CredentialsManager {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Credential.class, (Object)new Credential.Deserializer()).create();
    private final Client client;
    private CommandRunner commandRunner = null;
    private char[] sessionKey = new char[0];
    private List<Credential> entries = new ArrayList<Credential>();
    private boolean keepTrying = true;
    private BitwardenConfig config;

    @Inject
    CredentialsManager(Client client, BitwardenConfig config) {
        this.client = client;
        this.config = config;
    }

    private void parseIssue(String result) {
        this.commandRunner = null;
        this.entries.clear();
        if (result.contains("Session key is invalid")) {
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(null, "Your session key is invalid.", "", 1);
                this.askForKey();
            });
            return;
        }
        if (result.startsWith("? Master password:")) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Your vault is locked.", "", 1));
            return;
        }
        this.clearSessionKey();
        if (result.contains("You are not logged in")) {
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(null, "You are not logged into Bitwarden CLI.", "", 1);
                this.askForKey();
            });
        } else if (result.contains("mac failed")) {
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(null, "Error loading vault. Your session key might be wrong.\nYou can try logging out of Bitwarden CLI and logging back in.", "", 0);
                this.askForKey();
            });
        } else {
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(null, "Error loading vault.\nTry logging out of Bitwarden CLI and logging back in.", "", 0);
                this.askForKey();
            });
        }
    }

    private void consumeResult(String result) {
        if (!result.startsWith("[")) {
            this.parseIssue(result);
            return;
        }
        try {
            this.entries = (List)GSON.fromJson(result, Credential.TYPE);
            this.setPassword();
        }
        catch (JsonParseException | NullPointerException e) {
            this.entries.clear();
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Error parsing credential results.", "", 0));
        }
        finally {
            this.commandRunner = null;
        }
    }

    private void setPassword() {
        String username = this.client.getUsername();
        for (Credential credential : this.entries) {
            if (credential == null || !username.equalsIgnoreCase(credential.getUsername())) continue;
            this.client.setPassword(new String(credential.getPassword()));
            return;
        }
    }

    void clearSessionKey() {
        this.sessionKey = new char[0];
    }

    void setSessionKey(char[] key) {
        this.sessionKey = Arrays.copyOf(key, key.length);
    }

    void clearEntries() {
        this.entries.clear();
    }

    void reset() {
        this.clearSessionKey();
        this.entries.clear();
        this.commandRunner = null;
        this.keepTrying = true;
    }

    void injectPassword() {
        if (this.sessionKey.length == 0) {
            this.askForKey();
        } else if (this.commandRunner == null && this.entries.isEmpty()) {
            this.commandRunner = new CommandRunner(this.config.bwLocation(), this.sessionKey, this::consumeResult);
            this.commandRunner.start();
        } else {
            this.setPassword();
        }
    }

    private void askForKey() {
        if (!this.keepTrying) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            JPanel panel = new JPanel();
            JLabel label = new JLabel("Session Key:");
            JPasswordField pass = new JPasswordField(128);
            panel.add(label);
            panel.add(pass);
            int option = JOptionPane.showOptionDialog(null, panel, "Bitwarden", 2, -1, null, null, "");
            if (option == 0) {
                this.setSessionKey(pass.getPassword());
                this.injectPassword();
            } else {
                this.keepTrying = false;
                this.clearSessionKey();
            }
        });
    }
}

