/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.bitwarden;

import com.google.common.base.CharMatcher;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.runelite.client.util.OSType;

class CommandRunner
extends Thread {
    private static final CharMatcher CHAR_MATCHER = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)"=+/"));

    CommandRunner(String bw, char[] sessionKey, Consumer<String> consumer) {
        super(() -> {
            try {
                ProcessBuilder pb = CommandRunner.buildCommand(bw, new String(sessionKey));
                pb.redirectErrorStream(true);
                Process p = pb.start();
                byte[] bytes = ByteStreams.toByteArray((InputStream)p.getInputStream());
                p.waitFor();
                consumer.accept(new String(bytes));
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        });
    }

    private static ProcessBuilder buildCommand(String bw, String sessionKey) {
        String filteredKey = CHAR_MATCHER.retainFrom((CharSequence)sessionKey);
        ArrayList<String> params = new ArrayList<String>();
        if (OSType.getOSType() == OSType.Windows) {
            params.add("cmd");
            params.add("/c");
        } else {
            params.add("bash");
            params.add("-c");
        }
        String redirect = OSType.getOSType() == OSType.Windows ? " < NUL" : " < /dev/null";
        params.add(bw + " list items --search runescape.com --session \"" + filteredKey + "\"" + redirect);
        return new ProcessBuilder(params);
    }
}

