/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.bitwarden;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import io.ryoung.bitwarden.BitwardenConfig;
import io.ryoung.bitwarden.CredentialsManager;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bitwarden")
public class BitwardenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BitwardenPlugin.class);
    @Inject
    private Client client;
    @Inject
    private BitwardenConfig config;
    @Inject
    private CredentialsManager credentialsManager;

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.credentialsManager.clearEntries();
            if (this.config.clearKeyOnLogin()) {
                this.credentialsManager.clearSessionKey();
            }
        }
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged event) {
        if (this.client.getGameState() != GameState.LOGIN_SCREEN) {
            return;
        }
        this.credentialsManager.injectPassword();
    }

    protected void startUp() throws Exception {
        String envKey = System.getenv("BW_SESSION");
        if (!Strings.isNullOrEmpty((String)envKey)) {
            this.credentialsManager.setSessionKey(envKey.toCharArray());
        }
        this.credentialsManager.injectPassword();
    }

    protected void shutDown() throws Exception {
        this.credentialsManager.reset();
    }

    @Provides
    BitwardenConfig provideConfig(ConfigManager configManager) {
        return (BitwardenConfig)configManager.getConfig(BitwardenConfig.class);
    }
}

